function coazrec(featv,nonmissr) ;
% COAZREC, Reconstruction and Display of Zernike feature vectors
%      Corneal Topography Analysis System
%   Creates a map of the curvature, from a Zernike decomposition
%   in a new Figure Window
%      Intended to be called by coaram.m
% Input:
%       featv - Zernike feature vector (in standard order)
% Output:
%     Only graphics, in current Figure

%    Copyright (c) J. S. Marron, N. Locantore, 1998
%    Department of Statistics, University of North Carolina



%  Set local parameters
%
ngrid = 64 ;     %  Construct surfaces as ngrid x ngrid array



%  Set up global variables
%
%  First some general globals
global INFILESTR R0 NMAX COMAP ;
%  INFILESTR - string with input filename
%  R0 - radius of analysis
          %    this gets reloaded when a feature vec is reloaded from file
%  NMAX - maximum number of Zernike columns
          %    this gets reloaded when a feature vec is reloaded from file
%  COMAP - Color Map

%  Next the paths for file control
global INDATPATH ;
%  INDATPATH - path for input Keratron files

%  Next the globals for handles to figure windows and plots
global DDMHAND RDHANDPOS;
%  DDMHAND - handle for Figure Window with Display, Decomposition Menu
%  RDHANDPOS - handle for placement of figure window

%  Calculate grid quantities
%
xgrid = linspace(-R0, R0, ngrid) ;
ygrid = xgrid ;	        %  Vectors of image coordinate values 



%  Create image with Keratron Color scheme
%
mout = coazr(featv) ;



%  Create New Window for This plot
%
rdhand = figure ;
set(rdhand,'Position', RDHANDPOS) ;



%  Generate map
%
pcolor(xgrid,ygrid,mout) ;
  shading flat ;
  axis('square') ;
    titstr = ['Full Zernike Rec. for ' INFILESTR] ;
  title(titstr) ;
    caxis([0 1]) ;
  colormap(COMAP) ;

%  Show where missing data is:
hold on ;
  adata = linspace(0, (1 - 1/256) * 2 * pi, 256)' ;
  polar(adata,nonmissr,'-k') ;    
hold off ;



