function coa2pm
% COA2PM, 2 Population Menu Generation for Cornean
%      Corneal Topography Analysis System
%   Creates a menu in the current Figure Window
%      Intended to be called by cornean.m
% Outputs:
%     Only graphics, in current Figure

%    Copyright (c) J. S. Marron 1998
%    Department of Statistics, University of North Carolina


%  Set up global variables
%
%  First some general globals
global LISTFILESTR1 LISTFILESTR2 SETLIST1PATH SETLIST2PATH LISTR ;
%  LISTFILESTR1 - string with input name of file with list of filenames
%  LISTFILESTR2 - string with input name of file with list of filenames
%  SETLISTPATH1,2 - strings to set paths to lists
%  LISTR - string for inputting list file

global MATLABVER R0 NMAX COMAP NRPT NRIF ;
%  MATLABVER - version of Matlab, either 4 or 5
%  R0 - radius of analysis
          %    this gets reloaded when a feature vec is reloaded from file
%  NMAX - maximum number of Zernike columns
          %    this gets reloaded when a feature vec is reloaded from file
%  COMAP - Color Map
%  NRPT - Number of times to Repeat Movie
%  NRIF - Number of times to Repeat Individual Movie Frames
          %    (controls speed of .mpeg version)

global SCREENWD SCREENHT MENUWD ;
        % overall sizes of display area, generic menu width
global VERTGAP HORIZGAP TITLHT BUTTONHT
        %  generic sizes of objects on menus

%  Next the path for file control
global FEATMPATH OUTPUTPATH ;
%  FEATMPATH - path for storing Zernike feature matrices
%  OUTPUTPATH - path for output, .ps files, .mpeg files

%  Next the globals for handles to figure windows and plots
global PM2HAND PM2HANDPOS PM2ET1HAND PM2ET2HAND VLWZRHAND ;
%  PM2HAND - handle for Figure Window with 2 Population Menu
%  PM2HANDPOS - Position coordinates for Two Population Menu
%  PM2ET1HAND - handle for editable text, with input file prefix
%  PM2ET2HAND - handle for editable text, with input file prefix
%  VLWZRHAND - vector of handles for List-Wise Zernike Recon's
global DPCAHANDPOS DPCAM1POS DPCAM2POS DPCAM3POS DPCAM4POS SPCAHANDPOS ;
%  DPCAHANDPOS - Position coordinates for Movie Control Menu
%  DPCAM1POS - Position coordinates for PCA Movie 1
%  DPCAM2POS - Position coordinates for PCA Movie 2
%  DPCAM3POS - Position coordinates for PCA Movie 3
%  DPCAM4POS - Position coordinates for PCA Movie 4
%  SPCAHANDPOS - Position coordinates for Static PCA plot
global LWZRHANDPOS ;
%  LWZRHANDPOS - Position coordinates for List-Wise Zernike recons
global DPCAM1HAND DPCAM2HAND DPCAM3HAND DPCAM4HAND SPC2HAND ;
        %  Handles for movie windows in Dynamic and Static PC Analysis
global DPCAM1 DPCAM2 DPCAM3 DPCAM4 ;
        %  Movie matrices in Dynamic PC Analysis
global RFILESUF HFILESUF ;
        %  File Suffixes for data files
global PC2STR PC2LOAD1 PC2LOAD2 ;
        %  PC2STR - String with title info for 2 population analyses
        %  PC2LOAD1 - 1st Population Loadings for 2 population analyses
        %  PC2LOAD2 - 2nd Population Loadings for 2 population analyses


%  Initialize list paths, in case default is unacceptable
%
eval(SETLIST1PATH) ;
eval(SETLIST2PATH) ;




%  Create 2 Population Menu window and set up basics
%
if isempty(PM2HAND) ;          %  then need a new window
  PM2HAND = figure ;
else ;                     %  then work with existing menu
  figure(PM2HAND) ;
end ;
clf ;
set(PM2HAND, 'NumberTitle', 'off');
set(PM2HAND,'Position', [PM2HANDPOS]) ;
set(PM2HAND,'Name','2 Pop''n Menu') ;





%  Create header
%
titly = PM2HANDPOS(4) - (TITLHT + VERTGAP) ;
          %  get y coord of starting point working down from top
titlwd = (MENUWD - 2 * HORIZGAP) ;
h1s = 'Corneal Topography Analysis System' ;
          %  string to display as header, window size was chosen 
          %  to make this split correctly
pamh1hand = uicontrol(PM2HAND,'Style','text',...
            'Position',[HORIZGAP titly titlwd TITLHT],...
            'String',h1s, 'BackgroundColor', [0 0 0], ...
 	    'ForegroundColor', [0 1 1]);



%  Create Editable text, for entering 1st population list filename prefix
%
t1s = 'Population 1 File List Prefix:' ;
          %  text to display in front of entry field
twd = PM2HANDPOS(3) - 2 * HORIZGAP ;
          %  total width for this field
twd1 = .7 * twd ;
twd2 = .3 * twd ;
          %  respective parts for the label and editable text
ty = PM2HANDPOS(4) - (TITLHT + BUTTONHT + 2 * VERTGAP) ;
          %  get y coord of starting point working down from top
pm2t1hand = uicontrol(PM2HAND,'Style','text',...
              'Position',[HORIZGAP ty twd1 BUTTONHT],...
              'String',t1s,...
              'ForegroundColor',[1 0 0]) ;
          %  Creation of text on Main menu, in front of entry field
PM2ET1HAND = uicontrol(PM2HAND,'Style','Edit',...
                    'String',LISTFILESTR1,...
                    'Position',[(HORIZGAP + twd1) ty twd2 BUTTONHT],...
                    'ForegroundColor',[1 0 0],...
                    'CallBack',['LISTFILESTR1 = get(PM2ET1HAND,''String'') ;',...
                    'eval(SETLIST1PATH) ;']) ;
          %  User types text into window, and then global variable
          %  "LISTFILESTR1" contains string with filename
          %  Note: "String" is just a starting default, known to be there



%  Create Editable text, for entering 2nd population list filename prefix
%
t1s = 'Population 2 File List Prefix:' ;
          %  text to display in front of entry field
twd = PM2HANDPOS(3) - 2 * HORIZGAP ;
          %  total width for this field
twd1 = .7 * twd ;
twd2 = .3 * twd ;
          %  respective parts for the label and editable text
ty = PM2HANDPOS(4) - (TITLHT + 2 * BUTTONHT + 3 * VERTGAP) ;
          %  get y coord of starting point working down from top
pm2t2hand = uicontrol(PM2HAND,'Style','text',...
              'Position',[HORIZGAP ty twd1 BUTTONHT],...
              'String',t1s,...
              'ForegroundColor',[0 1 1]) ;
          %  Creation of text on Main menu, in front of entry field
PM2ET2HAND = uicontrol(PM2HAND,'Style','Edit',...
                    'String',LISTFILESTR2,...
                    'Position',[(HORIZGAP + twd1) ty twd2 BUTTONHT],...
                    'ForegroundColor',[0 1 1],...
                    'CallBack',['LISTFILESTR2 = get(PM2ET2HAND,''String'') ;',...
                    'eval(SETLIST2PATH) ;']) ;
          %  User types text into window, and then global variable
          %  "LISTFILESTR2" contains string with filename
          %  Note: "String" is just a starting default, known to be there



%  Create push button for "Input List File Directory"
%
buttony = PM2HANDPOS(4) - (TITLHT + 3 * BUTTONHT + 4 * VERTGAP) ;
          %  get y coord of starting point working down from top
buttonwd = .3 * (MENUWD - 2 * HORIZGAP) ;
          %  only use 30% of usual width
pamcbs1 = ['disp(''Current List Files:'') ;'...
            'dir ' FEATMPATH '*.lst ;'] ;
          %  Population Analysis CallBack String 1: 
          %  shows currently available list files
mmb1hand = uicontrol(PM2HAND,'Style','push',...
              'Position',[HORIZGAP buttony buttonwd BUTTONHT],...
              'String','see Dir.',...
              'CallBack',pamcbs1) ;



%  Create push button for "Help"
%
buttonx = HORIZGAP + .7 * (MENUWD - 2 * HORIZGAP) ;
buttonwd = .3 * (MENUWD - 2 * HORIZGAP) ;
          %  only use 30% of usual width
pm2cbs2 = ['disp(''      The fields "File List Prefix:"'') ;'...
           'disp(''      need to have prefixes of files where '') ;'...
           'disp(''      ________.lst is in the "zfm" directory '') ;'...
           'disp('' '') ;'] ;
          %  Two Population Analysis CallBack String 2: 
          %  give some advice about file storage
mmb2hand = uicontrol(PM2HAND,'Style','push',...
              'Position',[buttonx buttony buttonwd BUTTONHT],...
              'String','Help',...
              'CallBack',pm2cbs2) ;



%  Setup general width parameters for following buttons
%
twd = MENUWD - 2 * HORIZGAP ;
          %  total width for this field
bwd1 = .45 * twd ;
bgap = .1 * twd ;
bwd2 = .45 * twd ;
          %  respective parts for the left and right buttons



%  Create push button for Static PCA plot
%
buttony = PM2HANDPOS(4) - (TITLHT + 4 * BUTTONHT + 5 * VERTGAP) ;
          %  get y coord of starting point working down from top
ddmcbs1 = 'coaspc2(1)' ;
          %  CallBack String 1: Calls coaspc2.m, for
          %          static 2 Population analysis 
          %      Argument 1:  do standard PCA
pamb1hand = uicontrol(PM2HAND,'Style','push',...
              'Position',[HORIZGAP buttony bwd1 BUTTONHT],...
              'String','Static PCA',...
              'CallBack',ddmcbs1) ;



%  Create push button for Dynamic PCA plots
%
ddmcbs3 = 'coadpc2(1)' ;
          %  CallBack String 3: Calls coadpc2.m, for
          %          dynamic 2 population analysis 
          %      Argument 1:  do standard PCA
pamb3hand = uicontrol(PM2HAND,'Style','push',...
              'Position',[(HORIZGAP+bwd1+bgap) buttony bwd2 BUTTONHT],...
              'String','Dynamic PCA',...
              'CallBack',ddmcbs3) ;



%  Create push button for Static ICS plot
%
buttony = PM2HANDPOS(4) - (TITLHT + 5 * BUTTONHT + 6 * VERTGAP) ;
          %  get y coord of starting point working down from top
ddmcbs4 = 'coaspc2(2)' ;
          %  CallBack String 4: Calls coaspc2.m, for
          %          static 2 Population analysis 
          %      Argument 2:  do Intra Class Spread analysis
pamb4hand = uicontrol(PM2HAND,'Style','push',...
              'Position',[HORIZGAP buttony bwd1 BUTTONHT],...
              'String','Static ICS',...
              'CallBack',ddmcbs4) ;



%  Create push button for Dynamic ICS plots
%
ddmcbs5 = 'coadpc2(2)' ;
          %  CallBack String 5: Calls coadpc2.m, for
          %          dynamic 2 population analysis 
          %      Argument 2:  do Intra Class Spread analysis
pamb5hand = uicontrol(PM2HAND,'Style','push',...
              'Position',[(HORIZGAP+bwd1+bgap) buttony bwd2 BUTTONHT],...
              'String','Dynamic ICS',...
              'CallBack',ddmcbs5) ;



%  Create push button for Draftsman's Plots
%
buttony = PM2HANDPOS(4) - (TITLHT + 6 * BUTTONHT + 7 * VERTGAP) ;
bwd3 = .25 * twd ;
bwd4 = .5 * twd ;
ddmcbs6 = 'coapcdp' ;
          %  CallBack String 6: Calls coapcdp.m, for
          %          2 population analysis, Draftsman's Plots
pamb6hand = uicontrol(PM2HAND,'Style','push',...
              'Position',[(HORIZGAP+bwd3) buttony bwd4 BUTTONHT],...
              'String','Draftsman''s Plots',...
              'CallBack',ddmcbs6) ;




%  Create push button for Printing PCA, ICS and Draftsman's Plots
%
buttony = PM2HANDPOS(4) - (TITLHT + 7 * BUTTONHT + 8 * VERTGAP) ;
ddmcbs7 = 'coaspc2p' ;
          %  CallBack String 7: Calls coaspc2p.m, for making print of
          %          current plot
pamb7hand = uicontrol(PM2HAND,'Style','push',...
              'Position',[HORIZGAP buttony bwd1 BUTTONHT],...
              'String','Print (.ps)',...
              'CallBack',ddmcbs7) ;



%  Create push button to save Dynamic PCA plots in Mpeg form
%
          %  get y coord of starting point working down from top
ddmcbs8 = 'coadpc2s' ;
          %  CallBack String 8: Calls coadpc2s.m, for saving
          %          2 populaiton dynamic analysis 
          %          movies as mpeg files
pamb8hand = uicontrol(PM2HAND,'Style','push',...
              'Position',[(HORIZGAP+bwd1+bgap) buttony bwd2 BUTTONHT],...
              'String','Save movies (.mpg)',...
              'CallBack',ddmcbs8) ;

