function rchoose
% RCHOOSE, Does reconstruction for user-specified Radial
% 	coefficients (via gui).
%    Creates a mapping of the cornea curvature with specified
%	coefficients.  Called by coaram.m
% Outputs:
%	Graphics in figure window.

%	Copyright (c) J.S. Marron, N. Locantore, 1998
%	Department of Statistics, University of North Carolina 

%  Set up global variables
%
%  First some general globals
global INFILESTR R0 NMAX RRAMVCIND;
%  INFILESTR - string with input filename
%  R0 - radius of analysis
          %    this gets reloaded when a feature vec is reloaded from file
%  NMAX - maximum number of Zernike columns
          %    this gets reloaded when a feature vec is reloaded from file
%  RRAMVCIND - Vector of indicators for coefficients in our out,
%                      in manually driven reconstruction

%  Next the paths for file control
global FEATMPATH SUBDIRSTR ;
%  FEATMPATH - path for storing Zernike feature matrices
%  SUBDIRSTR - current subdirectory (of both indata and outputs)

%  Next the globals for handles to figure windows and plots
global RRAMHAND RRAMCBHAND ;
%  RRAMHAND - handle for Figure Window with Reconstruct, Analyze Menu
%  RRAMCBHAND - handle for CheckBoxes in Reconstruct, Analyze Menu


fvfilestr = [FEATMPATH SUBDIRSTR INFILESTR '.mat'] ;  
eval(['load ' fvfilestr]) ;

vmask = [RRAMVCIND(1)] ;
	% initializes vmask with (0,0) terms checkbox flag
	% below fills in the rest of the radial grid
for neven = 1:2:(2*NMAX)-1 ;
  	i0freq = (neven-1)/2 * 3 + 2;
  	submask = RRAMVCIND(i0freq:i0freq + 2) ;
  	submask = ones(2,1) * submask' ;
  	submask = reshape(submask, 6 ,1) ;           
  	submask(3) = [] ;
  	vmask = [vmask; submask] ;
	end ; 


betahat = betahat .* vmask ;
coarrec(betahat,nonmissr) ;
    	titstr = ['Chosen Zernikes for ' INFILESTR] ;
  	title(titstr) ;

hold on ;
  	trigap = .03 * (2 * R0) ;
  	trilength = .2 * (2 * R0) ;
  	trijump = trilength / NMAX ;
  	tristartx = R0 - 2*trigap ;
  	tristarty = R0 ;
  	i = 0 ;
  	for n = 0:(2*NMAX) ;
    		if n/2 == round(n/2) ;
      			mstart = 0 ;
    		else ;
      			mstart = 1 ;
    			end ;
    		mend = min(2,n) ;
    		for m = mstart:2:mend ;
      			i = i + 1 ;
      			flag = RRAMVCIND(i) ;
      			xpt = tristartx + m * trijump ; 
      			ypt = tristarty - n * trijump ; 
      			if flag == 0 ;
          			plot(xpt,ypt,'.b') ;
      			else ;
          			plot(xpt,ypt,'.y') ;
      			end ;
      			vh = get(gca,'Children') ;
               set(vh(1),'MarkerSize',8) ;
          end ;
  		end ;
hold off ;

          %  Callback String for termwise reconstruction
          %    vmask -  vector of "weights" for coefficients
          %                 (same size as full feature vector)
          %    neven - index of blocks of even and odd frequencies
          %    i0freq -  index (in RRAMVCIND scheme) of 0 freq coeff
          %  last block creates triangle of indicators, showing which
          %      boxes were checked
