%%*****************************************************************************
%% unperm: undo the permutations applied in validate.
%%
%% [X,Z,Xiter,Ziter] = unperm(blk,permZ,X,Z,Xiter,Ziter);
%%
%% undoes the permutation introduced in validate.
%% can also be called if Xiter and Ziter have not been set as
%%
%% [X,Z] = unperm(blk,permZ,X,Z);
%%
%% SDPT3: version 3.0
%% Copyright (c) 1997 by
%% K.C. Toh, M.J. Todd, R.H. Tutuncu
%% Last modified: 2 Feb 01
%%*****************************************************************************
 
  function [X,Z,Xiter,Ziter] = unperm(blk,permZ,X,Z,Xiter,Ziter);
%%
  for p = 1:size(blk,1)
     pZ = permZ{p};
     if (strcmp(blk{p,1},'s') & ~isempty(pZ))
        [per,j,s] = find(pZ);
        X{p} = X{p}(per,per);
        Z{p} = Z{p}(per,per);
        if (nargin >= 5)
           Xiter{p} = Xiter{p}(per,per);
           Ziter{p} = Ziter{p}(per,per);
        end;
     end;
  end;
%%*****************************************************************************
