function chkdir(dirstr,callstr) 
% CHKDIR, Checks for the existence of a directory
% Input:
%     dirstr - string containing a full directory
%     callstr - (optional) name of calling subroutine
% Output:
%       Writes warning message to screen when directory not found

%    Copyright (c) J. S. Marron 1998


dirstruct = dir(dirstr) ;  %  Create Structure with list of
                                %  files in this directory
if size(dirstruct,1) == 0 ;        %  then this directory does not exist

  disp('') ;
  disp(['!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!']) ;
  if nargin <= 1 ;    %  then use input string
    disp(['!!!   Warning from chkdir.m:              !!!']) ;
  else ;              %  otherwise reference this subroutine
    disp(['!!!   Warning from ' callstr ]) ;
   end ;
  disp(['!!!   This subdirectory does not exist:   !!!']) ;
  disp(['!!!   ' dirstr]) ;
  disp(['!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!']) ;

end ;


