function coa2pm
% COA2PM, 2 Population Menu Generation for Cornean
%      Corneal Topography Analysis System
%   Creates a menu in the current Figure Window
%      Intended to be called by cornean.m
% Outputs:
%     Only graphics, in current Figure

%    Copyright (c) J. S. Marron 1998
%    Department of Statistics, University of North Carolina


%  Set up global variables
%
%  First some general globals
global LISTFILESTR1 LISTFILESTR2 SETLIST1PATH SETLIST2PATH LISTR ;
%  LISTFILESTR1 - string with input name of file with list of filenames
%  LISTFILESTR2 - string with input name of file with list of filenames
%  SETLISTPATH1,2 - strings to set paths to lists
%  LISTR - string for inputting list file

global SUBDIRSTR ;
%  SUBDIRSTR - current subdirectory (of both indata and outputs)

global R0 NMAX IBASIS IRECENT COMAP NRPT NRIF RMP RCP ATP ;
%  R0 - radius of analysis
          %    this gets reloaded when a feature vec is reloaded from file
%  NMAX - maximum number of Zernike columns
          %    this gets reloaded when a feature vec is reloaded from file
%  IBASIS - 1 for full (triangle), 2 for radial (3 row)
%  IRECENT - To recenter (or not) decompositions
%  COMAP - Color Map
%  NRPT - Number of times to Repeat Movie
%  NRIF - Number of times to Repeat Individual Movie Frames
          %    (controls speed of .mpeg version)
%  RMP - Robustness Mean Parameter
%  RCP - Robustness Covariance Parameter
%  ATP - Analyis Type Parameter (1 - PCA,  2 - ICS,  3 - PDA)

global SCREENWD SCREENHT MENUWD ;
        % overall sizes of display area, generic menu width
global VERTGAP HORIZGAP TITLHT BUTTONHT
        %  generic sizes of objects on menus

%  Next the path for file control
global FEATMPATH OUTPUTPATH ;
%  FEATMPATH - path for storing Zernike feature matrices
%  OUTPUTPATH - path for output, .ps files, .mpeg files

%  Next the globals for handles to figure windows and plots
global PM2HAND PM2HANDPOS PM2ET1HAND PM2ET2HAND VLWZRHAND ;
%  PM2HAND - handle for Figure Window with 2 Population Menu
%  PM2HANDPOS - Position coordinates for Two Population Menu
%  PM2ET1HAND - handle for editable text, with input file prefix
%  PM2ET2HAND - handle for editable text, with input file prefix
%  VLWZRHAND - vector of handles for List-Wise Zernike Recon's
global DPCAHANDPOS DPCAM1POS DPCAM2POS DPCAM3POS DPCAM4POS SPCAHANDPOS ;
%  DPCAHANDPOS - Position coordinates for Movie Control Menu
%  DPCAM1POS - Position coordinates for PCA Movie 1
%  DPCAM2POS - Position coordinates for PCA Movie 2
%  DPCAM3POS - Position coordinates for PCA Movie 3
%  DPCAM4POS - Position coordinates for PCA Movie 4
%  SPCAHANDPOS - Position coordinates for Static PCA plot
global LWZRHANDPOS ;
%  LWZRHANDPOS - Position coordinates for List-Wise Zernike recons
global DPCAM1HAND DPCAM2HAND DPCAM3HAND DPCAM4HAND ;
        %  Handles for movie windows in Dynamic PC Analysis
global SPC2HAND PCP2PHAND ;
        %  Handles for windows in Static PC Analysis
        %      and Parallel Coordinate Plots
global DPCAM1 DPCAM2 DPCAM3 DPCAM4 ;
        %  Movie matrices in Dynamic PC Analysis
global RFILESUF HFILESUF ;
        %  File Suffixes for data files
global PC2STR PC2LOAD1 PC2LOAD2 ;
        %  PC2STR - String with title info for 2 population analyses
        %  PC2LOAD1 - 1st Population Loadings for 2 population analyses
        %  PC2LOAD2 - 2nd Population Loadings for 2 population analyses
global M2PMRADBUT1 M2PMRADBUT2 M2PMRADBUT3 ;
        %  M2PMRADBUT1 - Mean Two Population Menu Radio Button 1
        %  M2PMRADBUT2 - Mean Two Population Menu Radio Button 2
        %  M2PMRADBUT3 - Mean Two Population Menu Radio Button 3
global C2PMRADBUT1 C2PMRADBUT2 C2PMRADBUT3 ;
        %  C2PMRADBUT1 - Covariance Two Pop'n Menu Radio Button 1
        %  C2PMRADBUT2 - Covariance Two Pop'n Menu Radio Button 2
        %  C2PMRADBUT3 - Covariance Two Pop'n Menu Radio Button 3
global A2PMRADBUT1 A2PMRADBUT2 A2PMRADBUT3 ;
        %  C2PMRADBUT1 - Analysis Type Two Pop'n Menu Radio Button 1
        %  C2PMRADBUT2 - Analysis Type Two Pop'n Menu Radio Button 2
        %  C2PMRADBUT3 - Analysis Type Two Pop'n Menu Radio Button 3



%  Default Robustness Parameters
%
RMP = 0 ;
RCP = 0 ;
ATP = 1 ;



%  Create 2 Population Menu window and set up basics
%
if isempty(PM2HAND) ;          %  then need a new window
  PM2HAND = figure ;
else ;                     %  then work with existing menu
  figure(PM2HAND) ;
end ;
clf ;
set(PM2HAND, 'NumberTitle', 'off');
set(PM2HAND,'Position', [PM2HANDPOS]) ;
set(PM2HAND,'Name','2 Pop''n Menu') ;





%  Create header
%
titly = PM2HANDPOS(4) - (TITLHT + VERTGAP) ;
          %  get y coord of starting point working down from top
titlwd = (MENUWD - 2 * HORIZGAP) ;
h1s = 'Corneal Topography Analysis System' ;
          %  string to display as header, window size was chosen 
          %  to make this split correctly
p2mh1hand = uicontrol(PM2HAND,'Style','text',...
            'Position',[HORIZGAP titly titlwd TITLHT],...
            'String',h1s, 'BackgroundColor', [0 0 0], ...
 	    'ForegroundColor', [0 1 1]);



%  Create Editable text, for entering 1st population list filename prefix
%
t1s = 'Population 1 File List Prefix:' ;
          %  text to display in front of entry field
twd = PM2HANDPOS(3) - 2 * HORIZGAP ;
          %  total width for this field
twd1 = .7 * twd ;
twd2 = .3 * twd ;
          %  respective parts for the label and editable text
ty = PM2HANDPOS(4) - (TITLHT + BUTTONHT + 2 * VERTGAP) ;
          %  get y coord of starting point working down from top
pm2t1hand = uicontrol(PM2HAND,'Style','text',...
              'Position',[HORIZGAP ty twd1 BUTTONHT],...
              'String',t1s,...
              'ForegroundColor',[1 0 0]) ;
          %  Creation of text on Main menu, in front of entry field
PM2ET1HAND = uicontrol(PM2HAND,'Style','Edit',...
                    'String',LISTFILESTR1,...
                    'Position',[(HORIZGAP + twd1) ty twd2 BUTTONHT],...
                    'ForegroundColor',[1 0 0],...
                    'CallBack',['LISTFILESTR1 = get(PM2ET1HAND,''String'') ;',...
                    'eval(SETLIST1PATH) ;']) ;
          %  User types text into window, and then global variable
          %  "LISTFILESTR1" contains string with filename
          %  Note: "String" is just a starting default, known to be there



%  Create Editable text, for entering 2nd population list filename prefix
%
t1s = 'Population 2 File List Prefix:' ;
          %  text to display in front of entry field
twd = PM2HANDPOS(3) - 2 * HORIZGAP ;
          %  total width for this field
twd1 = .7 * twd ;
twd2 = .3 * twd ;
          %  respective parts for the label and editable text
ty = PM2HANDPOS(4) - (TITLHT + 2 * BUTTONHT + 3 * VERTGAP) ;
          %  get y coord of starting point working down from top
pm2t2hand = uicontrol(PM2HAND,'Style','text',...
              'Position',[HORIZGAP ty twd1 BUTTONHT],...
              'String',t1s,...
              'ForegroundColor',[0 1 1]) ;
          %  Creation of text on Main menu, in front of entry field
PM2ET2HAND = uicontrol(PM2HAND,'Style','Edit',...
                    'String',LISTFILESTR2,...
                    'Position',[(HORIZGAP + twd1) ty twd2 BUTTONHT],...
                    'ForegroundColor',[0 1 1],...
                    'CallBack',['LISTFILESTR2 = get(PM2ET2HAND,''String'') ;',...
                    'eval(SETLIST2PATH) ;']) ;
          %  User types text into window, and then global variable
          %  "LISTFILESTR2" contains string with filename
          %  Note: "String" is just a starting default, known to be there



%  Create push button for "Input List File Directory"
%
buttony = PM2HANDPOS(4) - (TITLHT + 3 * BUTTONHT + 4 * VERTGAP) ;
          %  get y coord of starting point working down from top
buttonwd = .3 * (MENUWD - 2 * HORIZGAP) ;
          %  only use 30% of usual width
pamcbs1 = ['disp(''Current List Files:'') ;'...
            'eval([''dir '' FEATMPATH SUBDIRSTR ''*.lst ;'']) ;'] ;
          %  Population Analysis CallBack String 1: 
          %  shows currently available list files
mmb1hand = uicontrol(PM2HAND,'Style','push',...
              'Position',[HORIZGAP buttony buttonwd BUTTONHT],...
              'String','see Dir.',...
              'CallBack',pamcbs1) ;



%  Create push button for "Help"
%
buttonx = HORIZGAP + .7 * (MENUWD - 2 * HORIZGAP) ;
buttonwd = .3 * (MENUWD - 2 * HORIZGAP) ;
          %  only use 30% of usual width
pm2cbs2 = ['disp(''      The fields "File List Prefix:"'') ;'...
           'disp(''      need to have prefixes of files where '') ;'...
           'disp(''      ________.lst is in the "zfm" directory '') ;'...
           'disp('' '') ;'] ;
          %  Two Population Analysis CallBack String 2: 
          %  give some advice about file storage
mmb2hand = uicontrol(PM2HAND,'Style','push',...
              'Position',[buttonx buttony buttonwd BUTTONHT],...
              'String','Help',...
              'CallBack',pm2cbs2) ;



% Put line between sections
%
ly = PM2HANDPOS(4) - (TITLHT + 2 + 3 * BUTTONHT + 5 * VERTGAP) ;
          %  get y coord of starting point working down from top
line2hand = uicontrol(PM2HAND,'Style','text',...
            'Position',[1 ly PM2HANDPOS(3) 2],...
            'BackgroundColor', [0 0 .5]) ;
           %  Create line between simple recon, and smoothed recon
%%--------------------------------------------------------------------





%  Create Radio buttons, controlling robustness of mean
%
buttony = PM2HANDPOS(4) - (TITLHT + 2 + 4 * BUTTONHT + 6 * VERTGAP) ;
          %  get y coord of starting point working down from top
twd = MENUWD - 2 * HORIZGAP ;
          %  total width for this field
bwd = .2 * twd ;
bgap = (.2 / 3) * twd ;
          %  respective parts for the left and right buttons
%  First set text part
MRadioButtonText = uicontrol(PM2HAND,...
          'Style','text',...
          'String','Center:',...
          'Position',[HORIZGAP buttony bwd BUTTONHT]) ;
%  First radio button
M2PMRADBUT1 = uicontrol(PM2HAND,...
          'Style','radio',...
          'String','Mean',...
          'Value',1,...
          'Position',[(HORIZGAP+bwd+bgap) buttony bwd BUTTONHT],...
          'Callback',[...
               'set(M2PMRADBUT1,''Value'',1),'...
               'set(M2PMRADBUT2,''Value'',0),'...
               'set(M2PMRADBUT3,''Value'',0),'...
               'RMP = 0 ;']) ;
               %  Note this first resets all the radio buttons,
               %  then sets the global Robust Mean Parameter
          %  Value indicates which button is currently "pushed"
%  Second Radio Button
M2PMRADBUT2 = uicontrol(PM2HAND,...
          'Style','radio',...
          'String','S. L1',...
          'Position',[(HORIZGAP+2*bwd+2*bgap) buttony bwd BUTTONHT],...
          'Callback',[...
               'set(M2PMRADBUT1,''Value'',0),'...
               'set(M2PMRADBUT2,''Value'',1),'...
               'set(M2PMRADBUT3,''Value'',0),'...
               'RMP = 1 ;']) ;
               %  Note this first resets all the radio buttons,
               %  then sets the global Robust Mean Parameter
          %  Value indicates which button is currently "pushed"
%  Third Radio Button
M2PMRADBUT3 = uicontrol(PM2HAND,...
          'Style','radio',...
          'String','E. L1',...
          'Position',[(HORIZGAP+3*bwd+3*bgap) buttony bwd BUTTONHT],...
          'Callback',[...
               'set(M2PMRADBUT1,''Value'',0),'...
               'set(M2PMRADBUT2,''Value'',0),'...
               'set(M2PMRADBUT3,''Value'',1),'...
               'RMP = 2 ;']) ;
               %  Note this first resets all the radio buttons,
               %  then sets the global Robust Mean Parameter
          %  Value indicates which button is currently "pushed"



%  Create Radio buttons, controlling robustness of covariance
%
buttony = PM2HANDPOS(4) - (TITLHT + 2 + 5 * BUTTONHT + 7 * VERTGAP) ;
          %  get y coord of starting point working down from top
twd = MENUWD - 2 * HORIZGAP ;
          %  total width for this field
bwd = .2 * twd ;
bgap = (.2 / 3) * twd ;
          %  respective parts for the left and right buttons
%  First set text part
CRadioButtonText = uicontrol(PM2HAND,...
          'Style','text',...
          'String','Scale:',...
          'Position',[HORIZGAP buttony bwd BUTTONHT]) ;
%  First radio button
C2PMRADBUT1 = uicontrol(PM2HAND,...
          'Style','radio',...
          'String','Covar.',...
          'Value',1,...
          'Position',[(HORIZGAP+bwd+bgap) buttony bwd BUTTONHT],...
          'Callback',[...
               'set(C2PMRADBUT1,''Value'',1),'...
               'set(C2PMRADBUT2,''Value'',0),'...
               'set(C2PMRADBUT3,''Value'',0),'...
               'RCP = 0 ;']) ;
               %  Note this first resets all the radio buttons,
               %  then sets the global Robust Mean Parameter
          %  Value indicates which button is currently "pushed"
%  Second Radio Button
C2PMRADBUT2 = uicontrol(PM2HAND,...
          'Style','radio',...
          'String','S. Cov.',...
          'Position',[(HORIZGAP+2*bwd+2*bgap) buttony bwd BUTTONHT],...
          'Callback',[...
               'set(C2PMRADBUT1,''Value'',0),'...
               'set(C2PMRADBUT2,''Value'',1),'...
               'set(C2PMRADBUT3,''Value'',0),'...
               'RCP = 1 ;']) ;
               %  Note this first resets all the radio buttons,
               %  then sets the global Robust Mean Parameter
          %  Value indicates which button is currently "pushed"
%  Third Radio Button
C2PMRADBUT3 = uicontrol(PM2HAND,...
          'Style','radio',...
          'String','E. Cov.',...
          'Position',[(HORIZGAP+3*bwd+3*bgap) buttony bwd BUTTONHT],...
          'Callback',[...
               'set(C2PMRADBUT1,''Value'',0),'...
               'set(C2PMRADBUT2,''Value'',0),'...
               'set(C2PMRADBUT3,''Value'',1),'...
               'RCP = 2 ;']) ;
               %  Note this first resets all the radio buttons,
               %  then sets the global Robust Mean Parameter
          %  Value indicates which button is currently "pushed"



%  Create Radio buttons, controlling Type of Analysis
%
buttony = PM2HANDPOS(4) - (TITLHT + 2 + 6 * BUTTONHT + 8 * VERTGAP) ;
          %  get y coord of starting point working down from top
twd = MENUWD - 2 * HORIZGAP ;
          %  total width for this field
bwd = .2 * twd ;
bgap = (.2 / 3) * twd ;
          %  respective parts for the left and right buttons
%  First set text part
ARadioButtonText = uicontrol(PM2HAND,...
          'Style','text',...
          'String','An. Type:',...
          'Position',[HORIZGAP buttony bwd BUTTONHT]) ;
%  First radio button
A2PMRADBUT1 = uicontrol(PM2HAND,...
          'Style','radio',...
          'String','PCA',...
          'Value',1,...
          'Position',[(HORIZGAP+bwd+bgap) buttony bwd BUTTONHT],...
          'Callback',[...
               'set(A2PMRADBUT1,''Value'',1),'...
               'set(A2PMRADBUT2,''Value'',0),'...
               'set(A2PMRADBUT3,''Value'',0),'...
               'ATP = 1 ;']) ;
               %  Note this first resets all the radio buttons,
               %  then sets the global Analysis Type Parameter
          %  Value indicates which button is currently "pushed"
%  Second Radio Button
A2PMRADBUT2 = uicontrol(PM2HAND,...
          'Style','radio',...
          'String','ICS',...
          'Position',[(HORIZGAP+2*bwd+2*bgap) buttony bwd BUTTONHT],...
          'Callback',[...
               'set(A2PMRADBUT1,''Value'',0),'...
               'set(A2PMRADBUT2,''Value'',1),'...
               'set(A2PMRADBUT3,''Value'',0),'...
               'ATP = 2 ;']) ;
               %  Note this first resets all the radio buttons,
               %  then sets the global Analysis Type Parameter
          %  Value indicates which button is currently "pushed"
%  Third Radio Button
A2PMRADBUT3 = uicontrol(PM2HAND,...
          'Style','radio',...
          'String','PDA',...
          'Position',[(HORIZGAP+3*bwd+3*bgap) buttony bwd BUTTONHT],...
          'Callback',[...
               'set(A2PMRADBUT1,''Value'',0),'...
               'set(A2PMRADBUT2,''Value'',0),'...
               'set(A2PMRADBUT3,''Value'',1),'...
               'ATP = 3 ;']) ;
               %  Note this first resets all the radio buttons,
               %  then sets the global Analysis Type Parameter
          %  Value indicates which button is currently "pushed"




% Put line between sections
%
ly = PM2HANDPOS(4) - (TITLHT + 4 + 6 * BUTTONHT + 9 * VERTGAP) ;
          %  get y coord of starting point working down from top
line2hand = uicontrol(PM2HAND,'Style','text',...
            'Position',[1 ly PM2HANDPOS(3) 2],...
            'BackgroundColor', [0 0 .5]) ;
           %  Create line between simple recon, and smoothed recon
%%--------------------------------------------------------------------




%  Setup general width parameters for following buttons
%
twd = MENUWD - 2 * HORIZGAP ;
          %  total width for this field
bwd1 = .45 * twd ;
bgap = .1 * twd ;
bwd2 = .45 * twd ;
          %  respective parts for the left and right buttons



%  Create push button for Parallel Coordinates plot
%
buttony = PM2HANDPOS(4) - (TITLHT + 4 + 7 * BUTTONHT + 10 * VERTGAP) ;
          %  get y coord of starting point working down from top
ddmcbs1 = 'coa2ppcp' ;
          %  CallBack String 1: Calls coa2ppcp.m, for
          %          2 Population Parallel Coordinates Plot 
pamb1hand = uicontrol(PM2HAND,'Style','push',...
              'Position',[HORIZGAP buttony bwd1 BUTTONHT],...
              'String','Parallel Coords',...
              'CallBack',ddmcbs1) ;


%  Create push button for Printing Parallel Coordinate Plots
%
ddmcbs2 = 'coa2pcpp' ;
          %  CallBack String 2: Calls coa2pcpp.m, for making print of
          %          current parallel coordinate plot
pamb2hand = uicontrol(PM2HAND,'Style','push',...
              'Position',[(HORIZGAP+bwd1+bgap) buttony bwd1 BUTTONHT],...
              'String','Print (.ps)',...
              'CallBack',ddmcbs2) ;




%  Create push button for Static Analysis plot
%
buttony = PM2HANDPOS(4) - (TITLHT + 4 + 8 * BUTTONHT + 11 * VERTGAP) ;
          %  get y coord of starting point working down from top
ddmcbs3 = 'coaspc2(ATP,RMP,RCP)' ;
          %  CallBack String 3: Calls coaspc2.m, for
          %          static 2 Population analysis 
pamb3hand = uicontrol(PM2HAND,'Style','push',...
              'Position',[HORIZGAP buttony bwd1 BUTTONHT],...
              'String','Static An.',...
              'CallBack',ddmcbs3) ;


%  Create push button for Printing Static Ann. Plots
%
ddmcbs4 = 'coaspc2p' ;
          %  CallBack String 4: Calls coaspc2p.m, for making print of
          %          current plot
pamb4hand = uicontrol(PM2HAND,'Style','push',...
              'Position',[(HORIZGAP+bwd1+bgap) buttony bwd1 BUTTONHT],...
              'String','Print (.ps)',...
              'CallBack',ddmcbs4) ;



%  Create push button for Dynamic Analysis plots
%
buttony = PM2HANDPOS(4) - (TITLHT + 4 + 9 * BUTTONHT + 12 * VERTGAP) ;
          %  get y coord of starting point working down from top
ddmcbs5 = 'coadpc2(ATP,RMP,RCP)' ;
          %  CallBack String 5: Calls coadpc2.m, for
          %          dynamic 2 population analysis 
pamb5hand = uicontrol(PM2HAND,'Style','push',...
              'Position',[HORIZGAP buttony bwd2 BUTTONHT],...
              'String','Dynamic An.',...
              'CallBack',ddmcbs5) ;


%  Create push button to save Dynamic PCA plots in Mpeg form
%
ddmcbs6 = 'coadpc2s' ;
          %  CallBack String 6: Calls coadpc2s.m, for saving
          %          2 population dynamic analysis 
          %          movies as mpeg files
pamb6hand = uicontrol(PM2HAND,'Style','push',...
              'Position',[(HORIZGAP+bwd1+bgap) buttony bwd2 BUTTONHT],...
              'String','Save movies (.mpg)',...
              'CallBack',ddmcbs6) ;




%  Create push button for Draftsman's Plots
%
buttony = PM2HANDPOS(4) - (TITLHT + 4 + 10 * BUTTONHT + 13 * VERTGAP) ;
          %  get y coord of starting point working down from top
bwd3 = .25 * twd ;
bwd4 = .5 * twd ;
ddmcbs7 = 'coapcdp' ;
          %  CallBack String 7: Calls coapcdp.m, for
          %          2 population analysis, Draftsman's Plots
pamb7hand = uicontrol(PM2HAND,'Style','push',...
              'Position',[HORIZGAP buttony bwd1 BUTTONHT],...
              'String','Draftsman''s Plots',...
              'CallBack',ddmcbs7) ;


%  Create push button for Printing Draftsman's Plots
%
ddmcbs8 = 'coaspc2p' ;
          %  CallBack String 8: Calls coaspc2p.m, for making print of
          %          current plot
pamb8hand = uicontrol(PM2HAND,'Style','push',...
              'Position',[(HORIZGAP+bwd1+bgap) buttony bwd1 BUTTONHT],...
              'String','Print (.ps)',...
              'CallBack',ddmcbs8) ;





