function coacpm
% COACPM, Change Parameter Menu Generation for Cornean
%      Corneal Topography Analysis System
%   Creates a menu in the current Figure Window
%      Intended to be called by cornean.m
% Outputs:
%     Only graphics, in current Figure

%    Copyright (c) J. S. Marron 1998
%    Department of Statistics, University of North Carolina


%  Set up global variables
%
%  First some general globals
global R0 NMAX IBASIS IRECENT COMAP NRPT NRIF ;
%  R0 - radius of analysis
          %    this gets reloaded when a feature vec is reloaded from file
%  NMAX - maximum number of Zernike columns
          %    this gets reloaded when a feature vec is reloaded from file
%  IBASIS - 1 for full (triangle), 2 for radial (3 row)
%  IRECENT - To recenter (or not) decompositions
%  COMAP - Color Map
%  NRPT - Number of times to Repeat Movie
%  NRIF - Number of times to Repeat Individual Movie Frames
          %    (controls speed of .mpeg version)

global SUBDIRSTR ;
%  SUBDIRSTR - current subdirectory (of both indata and outputs)

global SCREENWD SCREENHT MENUWD ;
        % overall sizes of display area, generic menu width
global VERTGAP HORIZGAP TITLHT BUTTONHT
        %  generic sizes of objects on menus


%  Next the globals for handles to figure windows and plots
global CPMHAND CPMHANDPOS CPMET1HAND CPMET2HAND CPMET3HAND ;
%  CPMHAND - handle for Figure Window with Individual Analysis Menu
%  CPMHANDPOS - Position coordinates for Individual Analysis Menu
%  CPMET1HAND - handle for editable text, for changing R0
%  CPMET2HAND - handle for editable text, for changing NMAX
%  CPMET3HAND - handle for editable text, with input file prefix

global BCPMRADBUT1 BCPMRADBUT2 ;
%  BCPMRADBUT1 - Basis Change Parameter Menu Radio Button 1
%  BCPMRADBUT2 - Basis Change Parameter Menu Radio Button 2

global RCPMRADBUT1 RCPMRADBUT2 ;
%  MCPMRADBUT1 - Recentering Population Analysis Menu Radio Button 1
%  MCPMRADBUT2 - Recentering Population Analysis Menu Radio Button 2




%  Create Change Parameter Menu window and set up basics
%
if isempty(CPMHAND) ;          %  then need a new window
  CPMHAND = figure ;
else ;                     %  then work with existing menu
  figure(CPMHAND) ;
end ;
clf ;
set(CPMHAND, 'NumberTitle', 'off');
set(CPMHAND,'Position', [CPMHANDPOS]) ;
set(CPMHAND,'Name','Change Parameter Menu') ;





%  Create header
%
titly = CPMHANDPOS(4) - (TITLHT + VERTGAP) ;
          %  get y coord of starting point working down from top
titlwd = (MENUWD - 2 * HORIZGAP) ;
h1s = 'Corneal Topography Analysis System' ;
          %  string to display as header, window size was chosen 
          %  to make this split correctly
cpmh1hand = uicontrol(CPMHAND,'Style','text',...
            'Position',[HORIZGAP titly titlwd TITLHT],...
            'String',h1s, 'BackgroundColor', [0 0 0], ...
 	    'ForegroundColor', [0 1 1]);




%  Create Editable text, for entering input R0
%
t1s = 'R0 (mm):' ;
          %  text to display in front of entry field
twd = CPMHANDPOS(3) - 2 * HORIZGAP ;
          %  total width for this field
twd1 = .2 * twd ;
twd2 = .2 * twd ;
          %  respective parts for the label and editable text
ty = CPMHANDPOS(4) - (TITLHT + BUTTONHT + 2 * VERTGAP) ;
          %  get y coord of starting point working down from top
cpmthand = uicontrol(CPMHAND,'Style','text',...
              'Position',[HORIZGAP ty twd1 BUTTONHT],...
              'String',t1s) ;
          %  Creation of text on Main menu, in front of entry field
CPMET1HAND = uicontrol(CPMHAND,'Style','Edit',...
                    'String',num2str(R0),...
                    'Position',[(HORIZGAP + twd1) ty twd2 BUTTONHT],...
                    'CallBack',...
                       ['r0str = get(CPMET1HAND,''String'') ;'...
                        'R0 = str2num(r0str) ;'...
                        'disp([''Changed R0 to: '' num2str(R0)]) ;'...
                           ]) ;
          %  User types text into window, which becomes the 
          %  string variable r0str, which is then turned into the
          %  global variable R0
          %  Note: "String" is just the starting default,
          %  known to be there



%  Create Editable text, for entering input NMAX
%
t2s = 'NMAX:' ;
          %  text to display in front of entry field
twd = CPMHANDPOS(3) - 2 * HORIZGAP ;
          %  total width for this field
twd1 = .6 * twd ;
twd2 = .2 * twd ;
          %  respective parts for the label and editable text
ty = CPMHANDPOS(4) - (TITLHT + BUTTONHT + 2 * VERTGAP) ;
          %  get y coord of starting point working down from top
cpmthand = uicontrol(CPMHAND,'Style','text',...
              'Position',[(HORIZGAP + twd1) ty twd2 BUTTONHT],...
              'String',t2s) ;
          %  Creation of text on Main menu, in front of entry field
CPMET2HAND = uicontrol(CPMHAND,'Style','Edit',...
                    'String',num2str(NMAX),...
                    'Position',[(HORIZGAP + twd1 + twd2) ty ...
                                                  twd2 BUTTONHT],...
                    'CallBack',...
                       ['nmaxstr = get(CPMET2HAND,''String'') ;'...
                        'NMAX = str2num(nmaxstr) ;'...
                        'disp([''Changed NMAX to: '' num2str(NMAX)]) ;'...
                           ]) ;
          %  User types text into window, which becomes the 
          %  string variable nmaxstr, which is then turned into the
          %  global variable NMAX
          %  Note: "String" is just the starting default,
          %  known to be there



%  Create Radio buttons, controlling basis type
%
buttony = CPMHANDPOS(4) - (TITLHT + 2 * BUTTONHT + 3 * VERTGAP) ;
          %  get y coord of starting point working down from top
twd = MENUWD - 2 * HORIZGAP ;
          %  total width for this field
bwd = .25 * twd ;
bgap = (.25 / 2) * twd ;
          %  respective parts for the left and right buttons
%  First set text part
BRadioButtonText = uicontrol(CPMHAND,...
          'Style','text',...
          'String','Basis:',...
          'Position',[HORIZGAP buttony bwd BUTTONHT]) ;
%  First radio button
if IBASIS == 1 ;
  startval1 = 1 ;   %  default starting value
  startval2 = 0 ;   %  default starting value
elseif IBASIS == 2 ;
  startval1 = 0 ;   %  default starting value
  startval2 = 1 ;   %  default starting value
end ;
BCPMRADBUT1 = uicontrol(CPMHAND,...
          'Style','radio',...
          'String','Full',...
          'Value',startval1,...
          'Position',[(HORIZGAP+bwd+bgap) buttony bwd BUTTONHT],...
          'Callback',[...
               'set(BCPMRADBUT1,''Value'',1),'...
               'set(BCPMRADBUT2,''Value'',0),'...
               'IBASIS = 1 ;']) ;
               %  Note this first resets all the radio buttons,
               %  then sets the global Robust Mean Parameter
          %  Value indicates which button is currently "pushed"
%  Second Radio Button
BCPMRADBUT2 = uicontrol(CPMHAND,...
          'Style','radio',...
          'String','Radial',...
          'Value',startval2,...
          'Position',[(HORIZGAP+2*bwd+2*bgap) buttony bwd BUTTONHT],...
          'Callback',[...
               'set(BCPMRADBUT1,''Value'',0),'...
               'set(BCPMRADBUT2,''Value'',1),'...
               'IBASIS = 2 ;']) ;
               %  Note this first resets all the radio buttons,
               %  then sets the global Robust Mean Parameter
          %  Value indicates which button is currently "pushed"



%  Create Radio Buttons for "Recentering"
%
buttony = CPMHANDPOS(4) - (TITLHT + 3 * BUTTONHT + 4 * VERTGAP) ;
          %  get y coord of starting point working down from top
twd = MENUWD - 2 * HORIZGAP ;
          %  total width for this field
bwd1 = .4 * twd ;
bgap = .1 * twd ;
bwd2 = .2 * twd ;
          %  respective parts for the left and right buttons
%  First set text part
RRadioButtonText = uicontrol(CPMHAND,...
          'Style','text',...
          'String','Decomp. Recenter:',...
          'Position',[HORIZGAP buttony bwd1 BUTTONHT]) ;
%  First radio button
if IRECENT == 0 ;
  startval1 = 1 ;   %  default starting value
  startval2 = 0 ;   %  default starting value
elseif IRECENT == 1 ;
  startval1 = 0 ;   %  default starting value
  startval2 = 1 ;   %  default starting value
end ;
RCPMRADBUT1 = uicontrol(CPMHAND,...
          'Style','radio',...
          'String','No',...
          'Value',startval1,...
          'Position',[(HORIZGAP+bwd1+bgap) buttony bwd2 BUTTONHT],...
          'Callback',[...
               'set(RCPMRADBUT1,''Value'',1),'...
               'set(RCPMRADBUT2,''Value'',0),'...
               'IRECENT = 0 ;']) ;
               %  Note this first resets all the radio buttons,
               %  then sets the global Robust Mean Parameter
          %  Value indicates which button is currently "pushed"
%  Second Radio Button
RCPMRADBUT2 = uicontrol(CPMHAND,...
          'Style','radio',...
          'String','Yes',...
          'Value',startval2,...
          'Position',[(HORIZGAP+bwd1+bwd2+2*bgap) buttony bwd2 BUTTONHT],...
          'Callback',[...
               'set(RCPMRADBUT1,''Value'',0),'...
               'set(RCPMRADBUT2,''Value'',1),'...
               'IRECENT = 1 ;']) ;
               %  Note this first resets all the radio buttons,
               %  then sets the global Robust Mean Parameter
          %  Value indicates which button is currently "pushed"




%  Create Editable text, for entering input Subdirectory
%
t3s = 'Subdir. (empty or ends with \ or /):' ;
          %  text to display in front of entry field
twd = CPMHANDPOS(3) - 2 * HORIZGAP ;
          %  total width for this field
twd1 = .7 * twd ;
twd2 = .3 * twd ;
          %  respective parts for the label and editable text
ty = CPMHANDPOS(4) - (TITLHT + 4 * BUTTONHT + 5 * VERTGAP) ;
          %  get y coord of starting point working down from top
cpmthand = uicontrol(CPMHAND,'Style','text',...
              'Position',[HORIZGAP ty twd1 BUTTONHT],...
              'String',t3s) ;
          %  Creation of text on Main menu, in front of entry field
CPMET3HAND = uicontrol(CPMHAND,'Style','Edit',...
                    'String',SUBDIRSTR,...
                    'Position',[(HORIZGAP + twd1) ty twd2 BUTTONHT],...
                    'CallBack',...
                       ['SUBDIRSTR = get(CPMET3HAND,''String'') ;'...
                        'chkdir([INDATPATH SUBDIRSTR],''coacpm.m'') ;'...
                        'chkdir([FEATMPATH SUBDIRSTR],''coacpm.m'') ;'...
                        'disp([''Changed Subdir. to: '' SUBDIRSTR]) ;'...
                           ]) ;
          %  User types text into window, and then global variable
          %  "SUBDIRSTR" contains string with filename
          %  Note: "String" is just a starting default, known to be there




