function coamam
% COAMAM, Difference Analysis Menu Generation for Cornean
%     (note, this menu was renamed from "Morphing Analysis"
%      Corneal Topography Analysis System
%   Creates a menu in the current Figure Window
%      Intended to be called by cornean.m
% Outputs:
%     Only graphics, in current Figure

%    Copyright (c) J. S. Marron 1998
%    Department of Statistics, University of North Carolina


%  Set up global variables
%
%  First some general globals
global R0 NMAX IBASIS IRECENT COMAP NRPT NRIF ;
%  R0 - radius of analysis
          %    this gets reloaded when a feature vec is reloaded from file
%  NMAX - maximum number of Zernike columns
          %    this gets reloaded when a feature vec is reloaded from file
%  IBASIS - 1 for full (triangle), 2 for radial (3 row)
%  IRECENT - To recenter (or not) decompositions
%  COMAP - Color Map
%  NRPT - Number of times to Repeat Movie
%  NRIF - Number of times to Repeat Individual Movie Frames
          %    (controls speed of .mpeg version)

global SCREENWD SCREENHT MENUWD ;
        % overall sizes of display area, generic menu width
global VERTGAP HORIZGAP TITLHT BUTTONHT
        %  generic sizes of objects on menus

%  Next the path for file control
global FEATMPATH OUTPUTPATH SUBDIRSTR ;
%  FEATMPATH - path for storing Zernike feature matrices
%  OUTPUTPATH - path for output, .ps files, .mpeg files
%  SUBDIRSTR - current subdirectory (of both indata and outputs)

%  Next the globals for handles to figure windows and plots
global MAMHAND MAMHANDPOS MAMETHAND MAMET1HAND MAMET2HAND MAMET3HAND ;
%  MAMHAND - handle for Figure Window for Morphing Analysis
%  MAMHANDPOS - Position coordinates for Morphing Analysis
%  MAMET1HAND - handle for editable text, with input file prefix
%  MAMET2HAND - handle for editable text, with input file prefix
%  MAMET3HAND - handle for editable text, with input file prefix

%  Next the strings with movie feature vector files
global M1FILESTR M2FILESTR M3FILESTR ;

%  Next the strings which reset the full filenames for movies
global SETM1PATH SETM2PATH SETM3PATH ;

%  Next set the input filename strings 
global M1STR M2STR M3STR ;

%  Next set the Movie Window handle
global MAMOVHAND ;

%  Next set the name of the movie matrix
global MAM ;



%  Create Difference Analysis Menu window and set up basics
%
if isempty(MAMHAND) ;          %  then need a new window
  MAMHAND = figure ;
else ;                     %  then work with existing menu
  figure(MAMHAND) ;
end ;
clf ;
set(MAMHAND, 'NumberTitle', 'off');
set(MAMHAND,'Position', [MAMHANDPOS]) ;
set(MAMHAND,'Name','Diff. Menu') ;



%  Create header
%
titly = MAMHANDPOS(4) - (TITLHT + VERTGAP) ;
          %  get y coord of starting point working down from top
titlwd = (MENUWD - 2 * HORIZGAP) ;
h1s = 'Corneal Topography Analysis System' ;
          %  string to display as header, window size was chosen 
          %  to make this split correctly
mamh1hand = uicontrol(MAMHAND,'Style','text',...
            'Position',[HORIZGAP titly titlwd TITLHT],...
            'String',h1s, 'BackgroundColor', [0 0 0], ...
 	    'ForegroundColor', [0 1 1]);



%  Create Radio Button for "Morph between 2 images"
%
rb1s = 'Will put radio button for 2 images' ;
rb1y = MAMHANDPOS(4) - (TITLHT + BUTTONHT + 2 * VERTGAP) ;
rbwd = MENUWD - 2 * HORIZGAP ;
mamthand = uicontrol(MAMHAND,'Style','text',...
              'Position',[HORIZGAP rb1y rbwd BUTTONHT],...
              'String',rb1s) ;
%  change this to a radio button after figuring out how to do that


%  Create Radio Button for "Morph between 3 images"
%
rb2s = 'Will put radio button for 3 images' ;
rb2y = MAMHANDPOS(4) - (TITLHT + 2 * BUTTONHT + 3 * VERTGAP) ;
rbwd = MENUWD - 2 * HORIZGAP ;
mamthand = uicontrol(MAMHAND,'Style','text',...
              'Position',[HORIZGAP rb2y rbwd BUTTONHT],...
              'String',rb2s) ;
%  change this to a radio button after figuring out how to do that


%  Create Editable text 1, for entering 1st feature filename prefix
%
t1s = '1st zfm file prefix:' ;
          %  text to display in front of entry field
twd = MAMHANDPOS(3) - 2 * HORIZGAP ;
          %  total width for this field
twd1 = .7 * twd ;
twd2 = .3 * twd ;
          %  respective parts for the label and editable text
ty = MAMHANDPOS(4) - (TITLHT + 3 * BUTTONHT + 4 * VERTGAP) ;
          %  get y coord of starting point working down from top
mamthand = uicontrol(MAMHAND,'Style','text',...
              'Position',[HORIZGAP ty twd1 BUTTONHT],...
              'String',t1s) ;
          %  Creation of text on Main menu, in front of entry field
MAMET1HAND = uicontrol(MAMHAND,'Style','Edit',...
                    'String',M1FILESTR,...
                    'Position',[(HORIZGAP + twd1) ty twd2 BUTTONHT],...
                    'CallBack',['M1FILESTR = get(MAMET1HAND,''String'') ;',...
                    'eval(SETM1PATH) ;']) ;
          %  User types text into window, and then global variable
          %  "M1FILESTR" contains string with movie 1 zfm filename
          %  Note: "String" is just a starting default, known to be there



%  Create Editable text 2, for entering 2nd feature filename prefix
%
t2s = '2nd zfm file prefix:' ;
          %  text to display in front of entry field
ty = MAMHANDPOS(4) - (TITLHT + 4 * BUTTONHT + 5 * VERTGAP) ;
          %  get y coord of starting point working down from top
mamthand = uicontrol(MAMHAND,'Style','text',...
              'Position',[HORIZGAP ty twd1 BUTTONHT],...
              'String',t2s) ;
          %  Creation of text on Main menu, in front of entry field
MAMET2HAND = uicontrol(MAMHAND,'Style','Edit',...
                    'String',M2FILESTR,...
                    'Position',[(HORIZGAP + twd1) ty twd2 BUTTONHT],...
                    'CallBack',['M2FILESTR = get(MAMET2HAND,''String'') ;',...
                    'eval(SETM2PATH) ;']) ;
          %  User types text into window, and then global variable
          %  "M2FILESTR" contains string with movie 2 zfm filename
          %  Note: "String" is just a starting default, known to be there


%%  Create Editable text 3, for entering 3rd feature filename prefix
%%
%t3s = '3rd zfm file prefix:' ;
%          %  text to display in front of entry field
%ty = MAMHANDPOS(4) - (TITLHT + 5 * BUTTONHT + 6 * VERTGAP) ;
%          %  get y coord of starting point working down from top
%mamthand = uicontrol(MAMHAND,'Style','text',...
%              'Position',[HORIZGAP ty twd1 BUTTONHT],...
%              'String',t3s) ;
%          %  Creation of text on Main menu, in front of entry field
%MAMET3HAND = uicontrol(MAMHAND,'Style','Edit',...
%                    'String',M3FILESTR,...
%                    'Position',[(HORIZGAP + twd1) ty twd2 BUTTONHT],...
%                    'CallBack',['M3FILESTR = get(MAMET3HAND,''String'') ;',...
%                    'eval(SETM3PATH) ;']) ;
%          %  User types text into window, and then global variable
%          %  "M3FILESTR" contains string with movie 3 zfm filename
%          %  Note: "String" is just a starting default, known to be there



%  Create push button for "Input zfm File Directory"
%
buttony = MAMHANDPOS(4) - (TITLHT + 6 * BUTTONHT + 7 * VERTGAP) ;
          %  get y coord of starting point working down from top
buttonwd = .3 * (MENUWD - 2 * HORIZGAP) ;
          %  only use 30% of usual width
mamcbs1 = ['disp(''Current Zernike Feature Matrix Files:'') ;'...
            'eval([''dir '' FEATMPATH SUBDIRSTR ''*.mat ;'']) ;'] ;
          %  Morphing Analysis CallBack String 1: 
          %  shows currently available zfm files
mmb1hand = uicontrol(MAMHAND,'Style','push',...
              'Position',[HORIZGAP buttony buttonwd BUTTONHT],...
              'String','see Dir.',...
              'CallBack',mamcbs1) ;



%  Create push button for "Help"
%
buttonx = HORIZGAP + .7 * (MENUWD - 2 * HORIZGAP) ;
buttonwd = .3 * (MENUWD - 2 * HORIZGAP) ;
          %  only use 30% of usual width
mamcbs2 = ['disp(''      The fields " zfm file prefix:"'') ;'...
           'disp(''      need to have the prefix of a file where '') ;'...
           'disp(''      ________.mat is in the "zfm" directory '') ;'...
           'disp('' '') ;'] ;
          %  Morphing Analysis CallBack String 2: 
          %  give some advice about file storage
mmb2hand = uicontrol(MAMHAND,'Style','push',...
              'Position',[buttonx buttony buttonwd BUTTONHT],...
              'String','Help',...
              'CallBack',mamcbs2) ;




%  Create push button for making new movie
%
buttony = MAMHANDPOS(4) - (TITLHT + 7 * BUTTONHT + 8 * VERTGAP) ;
          %  get y coord of starting point working down from top
buttonwd = MENUWD - 2 * HORIZGAP ;
ddmcbs3 = 'coamn' ;
          %  CallBack String 3: Calls coamn.m, for
          %          making a new morphing movie
mamb3hand = uicontrol(MAMHAND,'Style','push',...
              'Position',[HORIZGAP buttony buttonwd BUTTONHT],...
              'String','Make a new morphing movie',...
              'CallBack',ddmcbs3) ;



%  Create push button for rerunning last movie
%
buttony = MAMHANDPOS(4) - (TITLHT + 8 * BUTTONHT + 9 * VERTGAP) ;
          %  get y coord of starting point working down from top
buttonwd = MENUWD - 2 * HORIZGAP ;
ddmcbs4 = ['  figure(MAMOVHAND) ;' ...
           '  colormap(COMAP) ;' ...
           '  movie(MAMOVHAND,MAM,NRPT) ;'] ;
          %  CallBack String 4: Reruns last morphing movie
mamb4hand = uicontrol(MAMHAND,'Style','push',...
              'Position',[HORIZGAP buttony buttonwd BUTTONHT],...
              'String','Rerun last morphing movie',...
              'CallBack',ddmcbs4) ;



%  Create push button for saving last movie as mpeg file
%
buttony = MAMHANDPOS(4) - (TITLHT + 9 * BUTTONHT + 10 * VERTGAP) ;
          %  get y coord of starting point working down from top
buttonwd = MENUWD - 2 * HORIZGAP ;
ddmcbs4 = 'coams' ;
          %  CallBack String 4: Calls coams.m, for
          %          saving last morphing movie as an MPEG file
mamb3hand = uicontrol(MAMHAND,'Style','push',...
              'Position',[HORIZGAP buttony buttonwd BUTTONHT],...
              'String','Save last morphing movie (MPEG)',...
              'CallBack',ddmcbs4) ;



