%  Matlab script file cornean.m
%
%    This generates main control menu of Cornean
%    Cornea Topography Analysis System,
%      for Analysis of Data Generated by the Keratron 2000
%    This system performs tasks including display of an image,
%      decomposition into Zernike feature matrices,
%      and analyis of populations of feature matrices

%    (c) J. S. Marron and N. Locantore, 1998
%    Department of Statistics, University of North Carolina


%  First close all previous windows, and clear all variables
%
close all ;
clear all ;

verstr = '1.2' ;
disp(['Cornean: Cornea Topography Analysis System, ver. ' verstr]) ;
disp('(c) J. S. Marron and N. Locantore, 1998') ;
disp('Department of Statistics, University of North Carolina') ;
disp(' ') ;


%%=====================================================================

%  Define global variables
%
global R0 NMAX IBASIS IRECENT CRAD CANG COMAP HICURVE ;
	% R0, Maximum radius and NMAX, maximum zernike order for analysis
   % IBASIS, 1 for full (triangle), 2 for radial (3 row)
   % IRECENT, To recenter (or not) decompositions
        % CRAD, radius of recentering (read in as editable text)
        % CANG, angle of recentering (read in as editable text)
        % COMAP, Color Map
        % HICURVE, Gridpoints of Keratron range

global NRPT NRIF RMP RCP ATP ;
        % NRPT, Number of times to Repeat Movie
        % NRIF, Number of times to Repeat Individual Movie Frames
        %           (controls speed of .mpeg version)
        % RMP, Robustness Mean Parameter
        % RCP, Robustness Covariance Parameter
        % ATP, Analyis Type Parameter (for 2 Pop'n analyses)

global SCREENWD SCREENHT MENUWD ;
        % overall sizes of display area, generic menu width
global VERTGAP HORIZGAP TITLHT BUTTONHT
        %  generic sizes of objects on menus
global MMHAND IAMHAND PAMHAND MAMHAND IPMHAND PM2HAND CPMHAND ;
        %  MMHAND - handle for Figure Window with Main Menu
        %  IAMHAND - handle for Figure Window with Individual Analysis Menu
        %  PAMHAND - handle for Figure Window with Population Analysis Menu
        %  MAMHAND - handle for Figure Window with Morphing Analysis Menu
        %  IPMHAND - handle for Figure Window with Indiv. in Population Menu
        %  PM2HAND - handle for Figure Window with 2 Population Menu
        %  CPMHAND - handle for Figure Window with Change Parameter Menu
global RAMHAND RRAMHAND ;
        %  RAMHAND - handle for Figure Window with Reconstruct, Analyze Menu
        %  RRAMHAND - handle for Figure Window with Radial Recon/Analyze Menu

global IAMETHAND IAMETRHAND IAMETAHAND ;
        %  IAMETHAND - handle for editable text with data file prefix
        %  IAMETRHAND - handle for editable text, with input recentering radius
        %  IAMETAHAND - handle for editable text, with input recentering angle
global RAMCBHAND RAMSL1HAND RAMSL2HAND RAMSAXHAND ;
        %  RAMCBHAND - handle for CheckBoxes in Reconstruct, Analyze Menu
        %  RAMSL1HAND - handle for Slider for Mean of smooths
        %                              in Reconstruct, Analyze Menu
        %  RAMSL2HAND - handle for Slider for sd of smooths
        %                              in Reconstruct, Analyze Menu
        %  RAMSAXHAND - handle for SmoothDemo Axis, in Reconstruct, Analyze Menu
global RRAMCBHAND 
        %  RRAMCBHAND - handle for CheckBoxes in Radial Recon/Analyze Menu
global PAMETHAND PM2ET1HAND PM2ET2HAND VLWZRHAND ;
        %  PAMETHAND - handle for editable text with list file
        %  PM2ET1HAND - handle for editable text with list file
        %  PM2ET2HAND - handle for editable text with list file
        %  VLWZRHAND - vector of handles for List-Wise Zernike Recon's
global MAMET1HAND MAMET2HAND MAMET3HAND ;
        %  MAMET1HAND - handle for editable text with data file 1 prefix
        %  MAMET2HAND - handle for editable text with data file 2 prefix
        %  MAMET3HAND - handle for editable text with data file 3 prefix
global IPMETIHAND IPMETPHAND CPMET1HAND CPMET2HAND CPMET3HAND ;
        %  IPMETIHAND - handle for ed. text, with input file prefix for Indiv.
        %  IPMETPHAND - handle for ed. text, with input file prefix for Pop'n
        %  CPMET1HAND - handle for ed. text 1, In Change Parameter Window
        %  CPMET2HAND - handle for ed. text 2, In Change Parameter Window
        %  CPMET3HAND - handle for ed. text 3, In Change Parameter Window
global MMHANDPOS IAMHANDPOS PAMHANDPOS MAMHANDPOS IPMHANDPOS PM2HANDPOS ;
global CPMHANDPOS ;
global RAMHANDPOS RRAMHANDPOS RDHANDPOS PMAPHANDPOS LWZRHANDPOS ;
global DPCAHANDPOS DPCAM1POS DPCAM2POS DPCAM3POS DPCAM4POS ;
global SPCAHANDPOS IPCAHANDPOS ;
	% Figure window positioning handles
global INFILESTR SETPATHSTR RFILESUF HFILESUF CFILESUF;
        % Strings for individual data files
global RISTR HISTR CISTR INDATPATH FEATMPATH ;
        % More strings for individual data files
global OUTPUTPATH SUBDIRSTR;
        %  OUTPUTPATH - path for output, .ps files, .mpeg files
        %  SUBDIRSTR - current subdirectory (of both indata and outputs)
global LISTFILESTR LISTFILESTR1 LISTFILESTR2 LISTR ;
global SETLISTPATH SETCLISTPATH SETLIST1PATH SETLIST2PATH ;
        % strings for population lists
global M1FILESTR M2FILESTR M3FILESTR ;
        % strings with movie input filenames
global SETM1PATH SETM2PATH SETM3PATH M1STR M2STR M3STR ;
        % strings for setting movie paths
global DPCAM1HAND DPCAM2HAND DPCAM3HAND DPCAM4HAND DLWRMOVHAND
global SPCAHAND SPC2HAND MAMOVHAND ;
        %  Handles for movie windows in Dynamic and Static PC
        %  and morphing Analyses
global DPCAM1 DPCAM2 DPCAM3 DPCAM4 DLWRM MAM ; 
        %  Movie matrices in Dynamic PC, Listwise Recon.
        %  and Morphing Analysis
global IPCAHAND PCP1PHAND PCP2PHAND ;
        %  Handle for Indiv. in PC Analysis
        %  Handle for Parallel Coordinate Plots, 1 pop'n
        %  Handle for Parallel Coordinate Plots, 2 pop'ns
global RAMVCIND RRAMVCIND SMOMEAN SMOSD ;
        %  RAMVCIND - Vector of indicators for coefficients in our out,
        %                      in manually driven reconstruction
        %  RRAMVCIND - same as above, but for Radial reconstruction
        %  SMOMEAN - mean for smoothed reconstruction
        %  SMOSD - standard deviation for smoothed reconstruction
global PC2STR PC2LOAD1 PC2LOAD2 ;
        %  PC2STR - String with title info for 2 population analyses
        %  PC2LOAD1 - 1st Population Loadings for 2 population analyses
        %  PC2LOAD2 - 2nd Population Loadings for 2 population analyses
global MPAMRADBUT1 MPAMRADBUT2 MPAMRADBUT3 ;
        %  MPAMRADBUT1 - Mean Population Analysis Menu Radio Button 1
        %  MPAMRADBUT2 - Mean Population Analysis Menu Radio Button 2
        %  MPAMRADBUT3 - Mean Population Analysis Menu Radio Button 3
global CPAMRADBUT1 CPAMRADBUT2 CPAMRADBUT3 ;
        %  CPAMRADBUT1 - Covariance Pop'n Analysis Menu Radio Button 1
        %  CPAMRADBUT2 - Covariance Pop'n Analysis Menu Radio Button 2
        %  CPAMRADBUT3 - Covariance Pop'n Analysis Menu Radio Button 3
global MIPMRADBUT1 MIPMRADBUT2 MIPMRADBUT3 ;
        %  MIPMRADBUT1 - Mean Indiv. in Population Menu Radio Button 1
        %  MIPMRADBUT2 - Mean Indiv. in Population Menu Radio Button 2
        %  MIPMRADBUT3 - Mean Indiv. in Population Menu Radio Button 3
global CIPMRADBUT1 CIPMRADBUT2 CIPMRADBUT3 ;
        %  CIPMRADBUT1 - Covariance Indiv. in Pop'n Menu Radio Button 1
        %  CIPMRADBUT2 - Covariance Indiv. in Pop'n Menu Radio Button 2
        %  CIPMRADBUT3 - Covariance Indiv. in Pop'n Menu Radio Button 3
global M2PMRADBUT1 M2PMRADBUT2 M2PMRADBUT3 ;
        %  M2PMRADBUT1 - Mean Two Population Menu Radio Button 1
        %  M2PMRADBUT2 - Mean Two Population Menu Radio Button 2
        %  M2PMRADBUT3 - Mean Two Population Menu Radio Button 3
global C2PMRADBUT1 C2PMRADBUT2 C2PMRADBUT3 ;
        %  C2PMRADBUT1 - Covariance Two Pop'n Menu Radio Button 1
        %  C2PMRADBUT2 - Covariance Two Pop'n Menu Radio Button 2
        %  C2PMRADBUT3 - Covariance Two Pop'n Menu Radio Button 3
global A2PMRADBUT1 A2PMRADBUT2 A2PMRADBUT3 ;
        %  C2PMRADBUT1 - Analysis Type Two Pop'n Menu Radio Button 1
        %  C2PMRADBUT2 - Analysis Type Two Pop'n Menu Radio Button 2
        %  C2PMRADBUT3 - Analysis Type Two Pop'n Menu Radio Button 3
global RCPMRADBUT1 RCPMRADBUT2 ;
        %  MCPMRADBUT1 - Recentering Population Analysis Menu Radio Button 1
        %  MCPMRADBUT2 - Recentering Population Analysis Menu Radio Button 2
global BCPMRADBUT1 BCPMRADBUT2 ;
        %  BCPMRADBUT1 - Basis Change Parameter Menu Radio Button 1
        %  BCPMRADBUT2 - Basis Change Parameter Menu Radio Button 2





%%=====================================================================

%  Adjust this depending on environment where Cornean is running
%

ienviron = 1 ;  %%  1 -- denotes Standard PC file path
                %%  2 -- denotes monitor for Sun Workstation,
                %%             file path for Locantore
                %%  3 -- denotes monitor for Sun Workstation,
                %%             file path for Zhang
		%%  more here as necessary      



      
%%=====================================================================

%  This block contains environment dependent settings
%

if ienviron == 1;   % file path for environment 1, Generic PC
%  General globals
	NMAX = 10 ;
  	  %  maximum number of Zernikes to use	
	R0 = 4.2 ;
          %  radius of analysis
          %    these get reloaded when a feature vec is reloaded from file
   IBASIS = 1 ;
          % 1 for (triangular) Zernike basis, 2 for Radial version
   IRECENT = 0 ;
          % To recenter (1) or not (1) decompositions

	MENUWD = 300 ;
          %  Generic Menu Width
        VERTGAP = 12 ;
          %  Vertical gaps between buttons, etc.
        HORIZGAP = 20 ;
          %  Horizontal gap between buttons, etc.
        TITLHT = 20 ;
          %  Height of Title Fields
        BUTTONHT = 18 ;
          %  Height of Button Fields
          %      set these to just include all text lines in menus

        screenfact = 1 ;
          %  set this bigger than one to make single image plots bigger

	INFILESTR = '000121_2' ;    
          %  default file name for input         
          %  Favorites are:  000121_2   (good standard Kerataconus)
          %                  000084_1   (central Kerataconus)
          %                  000053_1   (PRK big red ring)
          %                  000139_2   (PRK, wide ring, so thin outer boundary)
          %                  000006_1   (Normal)
	RFILESUF = '.xlb' ;
          %  radii data file suffix 
   	HFILESUF = '.zlb' ;
          %  height data file suffix
   	CFILESUF = '.tlb' ;
          %  curvature data file suffix

        LISTFILESTR = 'egnorm' ;
        LISTFILESTR1 = 'egnorm' ;
        LISTFILESTR2 = 'egkercli' ;
          %  default file list

	INDATPATH = '\matlab\cornean\indata\' ;
          %  path for input Keratron files
	FEATMPATH = '\matlab\cornean\zfm\' ;
          %  path for storing Zernike feature matrices
	OUTPUTPATH = '\matlab\cornean\outputs\' ;
          %  path for output, .ps files, .mpeg files
   SUBDIRSTR = 'examples\' ;
        %  current subdirectory (of both indata and outputs)
        %  can be empty string, otherwise should end in '\' or '/'

        M1FILESTR = '000059_2' ;
        M2FILESTR = '000042_1' ;
          %  default movie files

        NRPT = 10 ;
          %  number of times to replay movies
          %      (don't use negative for "go back and forth",
          %              since is already handled (separately)
          %              individual contexts)

        NRIF = 4 ;
          %  number of time to repeat each frame of a movie
          %     (this is mostly to keep the mpeg saves from 
          %              running too fast)



%%--------------------------------------------------------------------


elseif ienviron == 2;   % environment for Locantore's Unix, Matlab 5
%  General globals
	NMAX = 10 ;
  	  %  maximum number of Zernikes to use	
	R0 = 4 ;
          %  radius of analysis
          %    these get reloaded when a feature vec is reloaded from file
   IBASIS = 1 ;
          % 1 for (triangular) Zernike basis, 2 for Radial version
   IRECENT = 0 ;
          % To recenter (1) or not (1) decompositions

	MENUWD = 300 ;
          %  Generic Menu Width
        VERTGAP = 12 ;
          %  Vertical gaps between buttons, etc.
        HORIZGAP = 20 ;
          %  Horizontal gap between buttons, etc.
        TITLHT = 25 ;
          %  Height of Title Fields
        BUTTONHT = 18 ;
          %  Height of Button Fields
          %      set these to just include all text lines in menus

        screenfact = 2 ;
          %  set this bigger than one to make single image plots bigger

	INFILESTR = '000188_1' ;    
          %  default file name for input   
	RFILESUF = '.xlb' ;
          %  radii data file suffix 
   	HFILESUF = '.zlb' ;
          %  height data file suffix
   	CFILESUF = '.tlb' ;
          %  curvature data file suffix

        LISTFILESTR = 'normal1' ;
          %  default file list

  INDATPATH = '/home/Mickey/students/locantor/cornean/indata/normal/';
          %  path for input Keratron files
	FEATMPATH = '/home/Mickey/students/locantor/cornean/zfm/' ;
          %  path for storing Zernike feature matrices
	OUTPUTPATH = '/home/Mickey/students/locantor/cornean/outputs/' ;
          %  path for output, .ps files, .mpeg files
   SUBDIRSTR = '' ;
        %  current subdirectory (of both indata and outputs)
        %  can be empty string, otherwise should end in '\' or '/'

        M1FILESTR = '000059_2' ;
        M2FILESTR = '000042_1' ;
          %  default movie files

        NRPT = 10 ;
          %  number of times to replay movies
          %      (don't use negative for "go back and forth",
          %              since is already handled (separately)
          %              individual contexts)

        NRIF = 4 ;
          %  number of time to repeat each frame of a movie
          %     (this is mostly to keep the mpeg saves from 
          %              running too fast)




%%--------------------------------------------------------------------


elseif ienviron == 3 ;   % environment for Zhang's Unix, Matlab 5
%  General globals
	NMAX = 10 ;
  	  %  maximum number of Zernikes to use	
	R0 = 3 ; % Originally 4, changed to 3 for conservative study by Jin-Ting 11/13/98
          %  radius of analysis
          %    these get reloaded when a feature vec is reloaded from file
   IBASIS = 1 ;
          % 1 for (triangular) Zernike basis, 2 for Radial version
   IRECENT = 0 ;
          % To recenter (1) or not (1) decompositions

	MENUWD = 300 ;
          %  Generic Menu Width
        VERTGAP = 12 ;
          %  Vertical gaps between buttons, etc.
        HORIZGAP = 20 ;
          %  Horizontal gap between buttons, etc.
        TITLHT = 25 ;
          %  Height of Title Fields
        BUTTONHT = 18 ;
          %  Height of Button Fields
          %      set these to just include all text lines in menus

        screenfact = 2 ;
          %  set this bigger than one to make single image plots bigger

	INFILESTR = '000182_1' ;   % Original 000188_1, changed to 000182_1 by JT 11/13/1998 
          %  default file name for input   
	RFILESUF = '.xlb' ;
          %  radii data file suffix 
   	HFILESUF = '.zlb' ;
          %  height data file suffix
   	CFILESUF = '.tlb' ;
          %  curvature data file suffix

        LISTFILESTR = 'normal1' ;
          %  default file list
          
  PATHSTR='/afs/isis.unc.edu/home/j/z/jzhang/Mickey/stat/cornean/';
     % Added by Jin-Ting for path searching 11/13/98
  INDATPATH = [PATHSTR, 'indata/'];
          %  path for input Keratron files
	FEATMPATH = [PATHSTR,'zfm/'] ;
          %  path for storing Zernike feature matrices
	OUTPUTPATH = [PATHSTR,'outputs/'];
          %  path for output, .ps files, .mpeg files
   SUBDIRSTR = '' ;
        %  current subdirectory (of both indata and outputs)
        %  can be empty string, otherwise should end in '\' or '/'

        M1FILESTR = '000059_2' ;
        M2FILESTR = '000042_1' ;
          %  default movie files

        NRPT = 10 ;
          %  number of times to replay movies
          %      (don't use negative for "go back and forth",
          %              since is already handled (separately)
          %              individual contexts)

        NRIF = 4 ;
          %  number of time to repeat each frame of a movie
          %     (this is mostly to keep the mpeg saves from 
          %              running too fast)


%%--------------------------------------------------------------------

end;


%  Set some common initial values
%
PC2STR = [] ;
PC2LOAD1 = [] ;
PC2LOAD2 = [] ;
          %  Set to empty, since 2 Pop'n Analysis has been run yet


%  Set up Keratron colormap
%
[COMAP, HICURVE] = coacmap ;




%  set and check subdirectory structure
%
chkdir([INDATPATH SUBDIRSTR],'cornean.m') 
chkdir([FEATMPATH SUBDIRSTR],'cornean.m') 

SETPATHSTR = [...
	'RISTR = [INDATPATH SUBDIRSTR INFILESTR RFILESUF] ;', ...
	'HISTR = [INDATPATH SUBDIRSTR INFILESTR HFILESUF] ;', ...
	'CISTR = [INDATPATH SUBDIRSTR INFILESTR CFILESUF] ;'] ;
          %  Set full filenames

SETLISTPATH = 'LISTR = [FEATMPATH SUBDIRSTR LISTFILESTR ''.lst''] ; ' ;
SETCLISTPATH = 'LISTR = [FEATMPATH SUBDIRSTR LISTFILESTR ''.cls''] ; ' ;
SETLIST1PATH = 'LISTR = [FEATMPATH SUBDIRSTR LISTFILESTR1 ''.lst''] ; ' ;
SETLIST2PATH = 'LISTR = [FEATMPATH SUBDIRSTR LISTFILESTR2 ''.lst''] ; ' ;
          %  Set full filename for list files

SETM1PATH = 'M1STR = [FEATMPATH SUBDIRSTR M1FILESTR] ;' ;
SETM2PATH = 'M2STR = [FEATMPATH SUBDIRSTR M2FILESTR] ;' ;
SETM3PATH = 'M3STR = [FEATMPATH SUBDIRSTR M3FILESTR] ;' ;
          %  Set full filenames for movie inputs

eval(SETPATHSTR) ;
eval(SETLISTPATH) ;
eval(SETLIST1PATH) ;
eval(SETLIST2PATH) ;
eval(SETM1PATH) ;
eval(SETM2PATH) ;
eval(SETM3PATH) ;
          %  Evaluate these to set default variables


%%=====================================================================


%  Get Screensize
%
ScreenSize = get(0,'ScreenSize') ;
          %  4-vector of screensize in pixels
SCREENWD = ScreenSize(3) ;
          %  screen width
SCREENHT = ScreenSize(4) ;
          %  screen height


%  Main Menu Window Positioning
%
mmwd = MENUWD ;
          %  width for main menu
nmmbutton = 6 ;
          %  Number of buttons to put on main menu
mmhdrht = 2 * TITLHT ;
          %  Main Menu Header Height (has more line than usual)
mmht = mmhdrht + nmmbutton * BUTTONHT + (nmmbutton + 2) * VERTGAP ;
          %  height for main menu
mmx = 1 ;
          %  put on left side
mmy = SCREENHT - mmht ;
          %  put at top
MMHANDPOS = [mmx, mmy, mmwd, mmht] ;


%  Individual Analysis Menu Positioning
%
iamwd = 1.05 * MENUWD ;
niambutton = 7 ;
          %  Number of buttons to put on Individual Analysis menu
iamht = TITLHT + niambutton * BUTTONHT + 2 * 2 + (niambutton + 4) * VERTGAP ;
          %  height for Individual Analysis menu, as:
          %    niambutton rows of buttons
          %    2 boundary lines (2 pixels deep)
iamx = 1 + 0.10 * SCREENWD ;
          %  put 10% from left side
iamy = SCREENHT - iamht - 0.13 * SCREENHT ;
          %  put 13% down from top
IAMHANDPOS  = [iamx,iamy,iamwd,iamht] ;


%  Difference Analysis Menu Positioning
%             (formerly called "morphing analysis")
%
mamwd = MENUWD ;
nmambutton = 9 ;
          %  Number of buttons to put on Difference Analysis menu
mamht = TITLHT + nmambutton * BUTTONHT + (nmambutton + 2) * VERTGAP ;
          %  height for Difference Analysis menu, as:
          %    nmambutton rows of buttons
mamx = 1 + 0.20 * SCREENWD ;
          %  put 20% from left side
mamy = SCREENHT - mamht - 0.13 * SCREENHT ;
          %  put 13% down from top
MAMHANDPOS  = [mamx,mamy,mamwd,mamht] ;


%  Population Analysis Menu Positioning
%
pamwd = MENUWD ;
npambutton = 10 ;
          %  Number of buttons to put on Population Analysis menu
pamht = TITLHT + npambutton * BUTTONHT + 2 * 2 + ...
                                         (npambutton + 4) * VERTGAP ;
          %  height for Population Analysis menu, as:
          %    npambutton rows of buttons
          %    2 boundary lines (2 pixels deep)
pamx = 1 + 0.30 * SCREENWD ;
          %  put 30% from left side
pamy = SCREENHT - pamht - 0.13 * SCREENHT ;
          %  put 13% down from top
PAMHANDPOS  = [pamx,pamy,pamwd,pamht] ;


%  Individual in Population Menu Positioning
%
ipmwd = MENUWD ;
nipmbutton = 8 ;
          %  Number of buttons to put on Individual in Population menu
ipmht = TITLHT + nipmbutton * BUTTONHT + (nipmbutton + 2) * VERTGAP ;
          %  height for Individual in Population menu, as:
          %    nipmbutton rows of buttons
ipmx = 1 + 0.40 * SCREENWD ;
          %  put 20% from left side
ipmy = SCREENHT - ipmht - 0.13 * SCREENHT ;
          %  put 13% down from top
IPMHANDPOS  = [ipmx,ipmy,ipmwd,ipmht] ;


%  2 Population Menu Positioning
%
pm2wd = MENUWD ;
n2pmbutton = 10 ;
          %  Number of buttons to put on 2 Population menu
pm2ht = TITLHT + n2pmbutton * BUTTONHT + 2 * 2 + ...
                                         (n2pmbutton + 4) * VERTGAP ;
          %  height for 2 Population menu, as:
          %    n2pmbutton rows of buttons
          %    2 boundary lines (2 pixels deep)
pm2x = 1 + 0.50 * SCREENWD ;
          %  put 20% from left side
pm2y = SCREENHT - pm2ht - 0.13 * SCREENHT ;
          %  put 13% down from top
PM2HANDPOS  = [pm2x,pm2y,pm2wd,pm2ht] ;


%  Change Parameter Menu Positioning
%
cpmwd = MENUWD ;
ncpmbutton = 4 ;
          %  Number of buttons to put on Cahgne Parameter menu
cpmht = TITLHT + ncpmbutton * BUTTONHT + ...
                                (ncpmbutton + 2) * VERTGAP ;
          %  height for Population Analysis menu, as:
          %    npambutton rows of buttons
          %    2 boundary lines (2 pixels deep)
cpmx = 1 + 0.10 * SCREENWD ;
          %  put 20% from left side
cpmy = SCREENHT - cpmht - 0.60 * SCREENHT ;
          %  put 60% down from top
CPMHANDPOS  = [cpmx,cpmy,cpmwd,cpmht] ;


%  Single Image, Reconstruct Analyze Menu Positioning
%  WAS 490 400
ramwd = 160 + (40*NMAX) ;  %  here use old value that works well
ramht = 180 + (20*NMAX) ;  %  again use old value that works well
ramx = 1 + 0.10 * SCREENWD ;
          %  put 10% from left side
ramy = SCREENHT - ramht - 0.18 * SCREENHT ;
          %  put 18% down from top
RAMHANDPOS  = [ramx,ramy,ramwd,ramht] ;

%  Single Image, Radial Reconstruct Analyze Menu Positioning
%  
ramwd = 160 + (15*NMAX) ;  %  here use old value that works well
ramht = 180 + (35*NMAX) ;  %  again use old value that works well
ramx = 1 + 0.10 * SCREENWD ;
          %  put 10% from left side
ramy = SCREENHT - ramht - 0.18 * SCREENHT ;
          %  put 18% down from top
if ramy < 0 ;    %  if box starts below the screen bottom
  ramy = 0 ;            %  then start at bottom
  ramht = SCREENHT ;    %  and use full height of screen
end ;
RRAMHANDPOS  = [ramx,ramy,ramwd,ramht] ;

%  Raw Data, and Reconstructed single image positions
%
rdwd = screenfact * 2 * 64 + 40 ;
          %  2 * 64 + boundary stuff
rdht = screenfact * 2 * 64 + 60 ;
          %  2 * 64 + boundary stuff
rdx = SCREENWD - 1.3 * rdwd ;
rdy = SCREENHT - 1.5 * rdht ;
RDHANDPOS = [rdx rdy rdwd rdht] ;


%  Power Map Position
%
pmapwd = screenfact * 120 ;
pmapht = screenfact * 80 ;
pmapx = 1 + 0.03 * SCREENWD ;
pmapy = 1 + 0.03 * SCREENHT ;
PMAPHANDPOS = [pmapx pmapy pmapwd pmapht] ;


%  List-Wise Reconstruction Window Position
%
lwzrwd = .85 * SCREENWD ;
lwzrht = .85 * SCREENHT ;
lwzrx = .99 * SCREENWD - lwzrwd ;
lwzry = 1 + .05 * SCREENHT ;
LWZRHANDPOS = [lwzrx lwzry lwzrwd lwzrht] ;


%  Static PCA Window Position
%
spcawd = .85 * SCREENWD ;
spcaht = .85 * SCREENHT ;
spcax = 1 + .05 * SCREENWD ;
spcay = 1 + .05 * SCREENHT ;
SPCAHANDPOS = [spcax spcay spcawd spcaht] ;


%  Dynamic PCA Control Panel Position
%
dpcawd = MENUWD ;
dpcaht = BUTTONHT + 2 * VERTGAP ;
dpcax = 1 + 0.03 * SCREENWD ;
dpcay = 1 + 0.03 * SCREENHT ;
DPCAHANDPOS = [dpcax dpcay dpcawd dpcaht] ;


%  Dynamic PCA Movie Positions
%
dpcamwd = 128 + 20 ;
          %  2 * 64 + boundary stuff
dpcamht = 256 + 60 ;
          %  4 * 64 + boundary stuff
dpcam1x = .98 * SCREENWD - 4 * dpcamwd;
dpcam1y = SCREENHT - 2.0 * rdht ;
DPCAM1POS = [dpcam1x dpcam1y dpcamwd dpcamht] ;
dpcam2x = .98 * SCREENWD - 3 * dpcamwd;
dpcam2y = SCREENHT - 2.0 * rdht ;
DPCAM2POS = [dpcam2x dpcam2y dpcamwd dpcamht] ;
dpcam3x = .98 * SCREENWD - 2 * dpcamwd;
dpcam3y = SCREENHT - 2.0 * rdht ;
DPCAM3POS = [dpcam3x dpcam3y dpcamwd dpcamht] ;
dpcam4x = .98 * SCREENWD - dpcamwd;
dpcam4y = SCREENHT - 2.0 * rdht ;
DPCAM4POS = [dpcam4x dpcam4y dpcamwd dpcamht] ;

%  Individual in PCA Window Position
%
ipcawd = .85 * SCREENWD ;
ipcaht = .85 * SCREENHT ;
ipcax = 1 + .05 * SCREENWD ;
ipcay = 1 + .05 * SCREENHT ;
IPCAHANDPOS = [ipcax ipcay ipcawd ipcaht] ;




%%=====================================================================

%  Put Main Menu window on screen
%
MMHAND = figure(1) ;
          %  Use Figure 1 for Main Menu
clf ;
set(MMHAND,'Position', MMHANDPOS) ;
set(MMHAND,'NumberTitle', 'off') ; 
set(MMHAND,'Name','Cornean: Main Menu');

%  Create header text
%
titly = (2*mmhdrht/3) + nmmbutton * BUTTONHT + (nmmbutton + 1) * VERTGAP ;
titlwd = (MENUWD - 2 * HORIZGAP) ;
mmhhand = uicontrol(MMHAND,'Style','text',...
            'Position',[HORIZGAP titly titlwd (mmhdrht/3)],...
            'String','Corneal Topography Analysis System', ...	   
 	    'BackgroundColor', [0 0 0], ...
 	    'ForegroundColor', [0 1 1]);

titly = (mmhdrht/3) + nmmbutton * BUTTONHT + (nmmbutton + 1) * VERTGAP ;
mmhhand2 = uicontrol(MMHAND, 'Style','text',...
            'Position',[HORIZGAP titly titlwd (mmhdrht/3)],...
            'String',['ver. ' verstr '  (c) J.S.Marron, N.Locantore, 1998'], ...	   
 	    'BackgroundColor', [0 0 0], ...
 	    'ForegroundColor', [0 1 1]);

titly = nmmbutton * BUTTONHT + (nmmbutton + 1) * VERTGAP ;
mmhhand3 = uicontrol(MMHAND, 'Style','text',...
            'Position',[HORIZGAP titly titlwd (mmhdrht/3)],...
            'String','University of North Carolina, Chapel Hill', ...	   
 	    'BackgroundColor', [0 0 0], ...
 	    'ForegroundColor', [0 1 1]);




%  Create push button for "Create Individual Analysis Menu"
%
buttony = (nmmbutton - 1) * BUTTONHT + nmmbutton * VERTGAP ;
buttonwd = (MENUWD - 2 * HORIZGAP) ;
mmcbs1 = 'coaiam' ;
          %  Main Menu CallBack String 1: calls coaiam.m
mmb1hand = uicontrol(MMHAND,'Style','push',...
              'Position',[HORIZGAP buttony buttonwd BUTTONHT],...
              'String','Go to Individual Analysis Menu',...
              'CallBack',mmcbs1) ;



%  Create push button for "Create Difference Analysis Menu"
%
buttony = (nmmbutton - 2) * BUTTONHT + (nmmbutton - 1) * VERTGAP ;
mmcbs2 = 'coamam' ;
          %  Main Menu CallBack String 2: calls coamam.m
mmb2hand = uicontrol(MMHAND,'Style','push',...
              'Position',[HORIZGAP buttony buttonwd BUTTONHT],...
              'String','Go to Difference Analysis Menu',...
              'CallBack',mmcbs2) ;



%  Create push button for "Create Population Analysis Menu"
%
buttony = (nmmbutton - 3) * BUTTONHT + (nmmbutton - 2) * VERTGAP ;
mmcbs3 = 'coapam' ;
          %  Main Menu CallBack String 3: calls coapam.m
mmb3hand = uicontrol(MMHAND,'Style','push',...
              'Position',[HORIZGAP buttony buttonwd BUTTONHT],...
              'String','Go to Population Analysis Menu',...
              'CallBack',mmcbs3) ;



%  Create push button for "Create Individual in Population Menu"
%
buttony = (nmmbutton - 4) * BUTTONHT + (nmmbutton - 3) * VERTGAP ;
mmcbs4 = 'coaipm' ;
          %  Main Menu CallBack String 4: calls coaipm.m
mmb4hand = uicontrol(MMHAND,'Style','push',...
              'Position',[HORIZGAP buttony buttonwd BUTTONHT],...
              'String','Go to Individual in Population Menu',...
              'CallBack',mmcbs4) ;




%  Create push button for "Create Two Population Menu"
%
buttony = (nmmbutton - 5) * BUTTONHT + (nmmbutton - 4) * VERTGAP ;
mmcbs5 = 'coa2pm' ;
          %  Main Menu CallBack String 5: calls coa2pm.m
mmb5hand = uicontrol(MMHAND,'Style','push',...
              'Position',[HORIZGAP buttony buttonwd BUTTONHT],...
              'String','Go to Two Population Menu',...
              'CallBack',mmcbs5) ;



%  Create push button for "Create Parameter Change Menu"
%
buttony = (nmmbutton - 6) * BUTTONHT + (nmmbutton - 5) * VERTGAP ;
%mmcbs6 = 'coacpm' ;
mmcbs6 = 'coacpm' ;
          %  Main Menu CallBack String 6: calls coacpm.m
mmb6hand = uicontrol(MMHAND,'Style','push',...
              'Position',[HORIZGAP buttony buttonwd BUTTONHT],...
              'String','Go to Parameter Change Menu',...
              'CallBack',mmcbs6) ;
