disp('Running MATLAB script file PlotJbasis.m') ;
%

%    Makes plot of Jacobi Basis Functions


rgrid = linspace(-1,1,101)' ;


ifourier = 0 ;


for ijacob = 0:2:20 ;

  jpoly = jacobi(ijacob, ifourier) ;

  djpoly = polyder(jpoly) ;
  ddjpoly = polyder(djpoly) ;

  jacob = polyval(jpoly,rgrid) ;
  djacob = polyval(djpoly,rgrid) ;
  ddjacob = polyval(ddjpoly,rgrid) ;

  jcurv = ddjacob ./ (1 + djacob.^2).^(3/2) ;


  subplot(2,2,1) 
  plot(rgrid,jacob) ;
    title(['Fourier 0, Jacobi ' num2str(ijacob)]) ;
    vax = axis ;
    hold on ;
      plot([0; 0],[vax(3); vax(4)],'r-') ;
    hold off ;


  subplot(2,2,2) 
  plot(rgrid,djacob) ;
    title(['Fourier 0, Jacobi ' num2str(ijacob)]) ;
    vax = axis ;
    hold on ;
      plot([0; 0],[vax(3); vax(4)],'r-') ;
    hold off ;


  subplot(2,2,3) 
  plot(rgrid,ddjacob) ;
    title(['Fourier 0, Jacobi ' num2str(ijacob)]) ;
    vax = axis ;
    hold on ;
      plot([0; 0],[vax(3); vax(4)],'r-') ;
    hold off ;


  subplot(2,2,4) 
  plot(rgrid,jcurv) ;
    title(['Fourier 0, Jacobi ' num2str(ijacob)]) ;
    vax = axis ;
    hold on ;
      plot([0; 0],[vax(3); vax(4)],'r-') ;
    hold off ;





  pause ;



end ;   %  of loop through jacobi terms



