function coarram
% COARRAM, Radial Reconstruct Analyze Menu Generation for Cornean
%      Corneal Topography Analysis System
%   Creates a menu in the current Figure Window
%      Intended to be called by coaiam.m
% Outputs:
%     Only graphics, in a newly generated Figure

%    Copyright (c) J. S. Marron, N. Locantore 1998
%    Department of Statistics, University of North Carolina

%  Set up global variables
%
%  First some general globals
global INFILESTR R0 NMAX CRAD CANG RRAMVCIND  ;
%  INFILESTR - string with input filename
%  R0 - radius of analysis
          %    this gets reloaded when a feature vec is reloaded from file
%  NMAX - maximum number of Zernike columns
          %    this gets reloaded when a feature vec is reloaded from file
%  CRAD - radius of recentering (read in as editable text)
          %    this gets reloaded when a feature vec is reloaded from file
%  CANG - angle of recentering (read in as editable text)
          %    this gets reloaded when a feature vec is reloaded from file
%  RRAMVCIND - Vector of indicators for coefficients in our out,
%                      in manually driven reconstruction

%  Next the paths for file control
global FEATMPATH ;
%  FEATMPATH - path for storing Zernike feature matrices

%  Next the globals for handles to figure windows and plots
global RRAMHAND RRAMHANDPOS RRAMCBHAND  ;
%  RRAMHAND - handle for Figure Window with Reconstruct, Analyze Menu
%  RRAMCBHAND - handle for CheckBoxes in Radial Recon/Analyze Menu


%  Set Reconstruct / Analyze Menu window and set up basics
%
if isempty(RRAMHAND) ;          %  then need a new window
  RRAMHAND = figure ;
else ;                     %  then work with existing menu
  figure(RRAMHAND) ;
end ;
clf ;
set(RRAMHAND, 'NumberTitle', 'off');
set(RRAMHAND,'Position', RRAMHANDPOS) ;
set(RRAMHAND,'Name','Radial Recon Menu') ;




%  Set Positioning Parameters, etc.
%
pleft = 70 ;
ptop = RRAMHANDPOS(4)-110 ;
pxjump = 50 ;
if RRAMHANDPOS(2) == 0 ;    %  then there was some truncation of 
                            %  of the window done, so adjust heights
                            %  checkboxes
  pyjump = (ptop - 50) / (2*NMAX) ;
else ;
  pyjump = 20 ;
end ;


%  Create header
%
h1s = 'Corneal Topography Analysis System' ;
          %  string to display as header, window size was chosen 
          %  to make this split correctly
ramh1hand = uicontrol(RRAMHAND,'Style','text', ...
		'Position',[10 RRAMHANDPOS(4)-20 290 22],...
              'String',h1s, 'BackgroundColor', [0 0 0], ...
	      'ForegroundColor', [0 1 1]);






%  Create push button for Full Reconstruction
%
line1hand = uicontrol(RRAMHAND,'Style','text',...
            'Position',[0 RRAMHANDPOS(4)-24 RRAMHANDPOS(3) 2],...
            'BackgroundColor', [0 0 .5]) ;
           %  Create line between simple recon, and smoothed recon
ramcbs1 = ['fvfilestr = [FEATMPATH INFILESTR ''.mat''] ;' ...  
           'eval([''load '' fvfilestr]) ;' ...
           'coarrec(betahat,nonmissr) ;'] ;
          %  Callback String for simple reconstruction
ramb1hand = uicontrol(RRAMHAND,'Style','push','Position', ...
		[15 RRAMHANDPOS(4)-50 280 20],...
              'String','Full Radial Decomposition',...
              'CallBack',ramcbs1) ;





%  Now do chosen reconstruction pushbutton
%
line2hand = uicontrol(RRAMHAND,'Style','text',...
            'Position',[0 RRAMHANDPOS(4)-54 RRAMHANDPOS(3) 2],...
            'BackgroundColor', [0 0 .5]) ;
           %  Create line between full and chosen recon

ramcbs3 = 'rchoose' ;
	%  call function rchoose (too long for callback string)
	%  makes reconstruction for chosen coefficients

ramb3hand = uicontrol(RRAMHAND,'Style','push',...
              'Position',[15 RRAMHANDPOS(4)-80 280 20],...
              'String','Reconstruct with Chosen Terms (below)',...
              'CallBack',ramcbs3) ;


%  Create Environment for Chosen Reconstruction
%
%  Starting with array of pushbuttons for the coefficients
RRAMCBHAND = [] ;    %  initialize handles for small checkboxes
RRAMVCIND = [] ;     %  initialize values for small checkboxes
i = 0 ;    %  Index when coefficients grouped into a vector
for n = 0:(2*NMAX) ;   %  loop through Zernike columns (Jacobi orders)
  if n/2 == round(n/2) ;    %  for n even
    mstart = 0 ;   %  start at 0-th Fourier frequency
  else ;                    %  for n odd
    mstart = 1 ;   %  start at 1-st Fourier frequency
  end ;
  mend = min(n,2) ;   %  end at 2nd Fourier frequency

  for m = mstart:2:mend ;    %  Loop through Fourier frequencies
    i = i + 1 ;
    RRAMVCIND = [RRAMVCIND; 0] ;    %  Initialize everything to 0
    tempcbstr = ['RRAMVCIND(' num2str(i) ') = get(RRAMCBHAND(' num2str(i) ...
                      '),''Value'') ;'] ;
          %  CallBack String: when a box is checked/unchecked, update 
          %          vector of indicators for that coefficient
    temphand = uicontrol(RRAMHAND,'Style','checkbox',...
              'Position', ...
	      [(pleft+m*pxjump+10) (ptop-n*pyjump+2) pxjump pyjump],...
              'String',[num2str(m) ',' num2str(n)],...
              'CallBack',tempcbstr) ;
          %  String puts coefficient label on checkbox
    RRAMCBHAND = [RRAMCBHAND; temphand] ;
          %  build up vector of handles, because these are
          %         referenced when a box is checked
  end ;
end ;
%
