function coaram
% COARAM, Reconstruct, Analyze Menu Generation for Cornean
%      Corneal Topography Analysis System
%   Creates a menu in the current Figure Window
%      Intended to be called by cornean.m
% Outputs:
%     Only graphics, in current Figure

%    Copyright (c) J. S. Marron 1998
%    Department of Statistics, University of North Carolina



%  Set up global variables
%
%  First some general globals
global INFILESTR R0 NMAX RAMVCIND SMOMEAN SMOSD ;
%  INFILESTR - string with input filename
%  R0 - radius of analysis
          %    this gets reloaded when a feature vec is reloaded from file
%  NMAX - maximum number of Zernike columns
          %    this gets reloaded when a feature vec is reloaded from file
%  RAMVCIND - Vector of indicators for coefficients in our out,
%                      in manually driven reconstruction
%  SMOMEAN - mean for smoothed reconstruction
%  SMOSD - standard deviation for smoothed reconstruction

%  Next the paths for file control
global FEATMPATH ;
%  FEATMPATH - path for storing Zernike feature matrices

%  Next the globals for handles to figure windows and plots
global RAMHAND RAMHANDPOS RAMCBHAND RAMSL1HAND RAMSL2HAND RAMSAXHAND ;
%  RAMHAND - handle for Figure Window with Reconstruct, Analyze Menu
%  RAMCBHAND - handle for CheckBoxes in Reconstruct, Analyze Menu
%  RAMSL1HAND - handle for Slider for Mean of smooths
%                              in Reconstruct, Analyze Menu
%  RAMSL2HAND - handle for Slider for sd of smooths
%                              in Reconstruct, Analyze Menu
%  RAMSAXHAND - handle for SmoothDemo Axis, in Reconstruct, Analyze Menu



%  Set Reconstruct / Analyze Menu window and set up basics
%
if isempty(RAMHAND) ;          %  then need a new window
  RAMHAND = figure ;
else ;                     %  then work with existing menu
  figure(RAMHAND) ;
end ;
clf ;
set(RAMHAND, 'NumberTitle', 'off');
set(RAMHAND,'Position', RAMHANDPOS) ;
set(RAMHAND,'Name','Reconstruct/Analyze Menu  (Do Not Close)') ;




%  Set Positioning Parameters, etc.
%
pleft = 10 ;
ptop = 165 ;
pxjump = 40 ;
pyjump = 20 ;
RAMSAXHAND = [] ;



%  Create header
%
h1s = 'Corneal Topography Analysis System' ;
          %  string to display as header, window size was chosen 
          %  to make this split correctly
ramh1hand = uicontrol(RAMHAND,'Style','text','Position',[10 308 290 22],...
              'String',h1s, 'BackgroundColor', [0 0 0], ...
	      'ForegroundColor', [0 1 1]);






%  Create push button for Simple Reconstruction
%
ramcbs1 = ['fvfilestr = [FEATMPATH INFILESTR ''.mat''] ;' ...  
           'eval([''load '' fvfilestr]) ;' ...
           'coazrec(betahat) ;'] ;
          %  Callback String for simple reconstruction
ramb1hand = uicontrol(RAMHAND,'Style','push','Position',[390 300 99 20],...
              'String','Full Recon.',...
              'CallBack',ramcbs1) ;
line1hand = uicontrol(RAMHAND,'Style','text',...
            'Position',[0 296 490 2],...
            'BackgroundColor', [0 0 .5]) ;
           %  Create line between simple recon, and smoothed recon




%  Create Environment for Smoothed Reconstruction
%
%  Starting with sliders for bandwidths
SMOMEAN = mean([0; NMAX]) ;    %  default value
SMOSD = 1 ;                   %  default value
smoplotstr = ['xgrid = linspace(0,NMAX,100)'' ;' ...
              'smofun = 1 - phi((xgrid - SMOMEAN) / SMOSD) ;' ...
              'if isempty(RAMSAXHAND) ;' ...
              '  axpos = [.06 .65 (.06 + NMAX * .08) .1] ;' ...
              '  RAMSAXHAND = axes(''Position'',axpos) ;' ...
              'else ;' ...
              '  axes(RAMSAXHAND) ;' ...
              'end ;' ...
              'cla ;' ...
              'plot(xgrid,smofun,[SMOMEAN; SMOMEAN], [0; 1]) ;' ...
              'axis([0 NMAX 0 1]) ;'] ;
          %  String to make/remake smoothing window plot
ramsl1thand = uicontrol(RAMHAND,'Style','text',...
              'Position',[10 270 40 15],...
              'String','mean') ;
          %  Puts text in front of mean slider
tempcbs = ['SMOMEAN = get(RAMSL1HAND,''Value'') ;' smoplotstr] ;
          %  this call back string gets the mean value from the mean slider,
          %            then reconstructs the plot
RAMSL1HAND = uicontrol(RAMHAND,'Style','slider',...
            'Position',[55 270 150 15],...
            'Min',0,'Max',NMAX,'Value',SMOMEAN,...
            'CallBack',tempcbs) ;
          %  creates mean slider, with endpoints, and starting default
ramsl2thand = uicontrol(RAMHAND,'Style','text','Position',[220 270 30 15],...
              'String','sd') ;
          %  Puts text in front of sd slider
tempcbs = ['SMOSD = get(RAMSL2HAND,''Value'') ;' smoplotstr] ;
          %  this call back string gets the sd value from the sd slider,
          %            then reconstructs the plot
RAMSL2HAND = uicontrol(RAMHAND,'Style','slider',...
            'Position',[255 270 150 15],...
            'Min',0.01,'Max',NMAX/2,'Value',SMOSD,...
            'CallBack',tempcbs) ;
          %  creates sd slider, with endpoints, and starting default
eval(smoplotstr) ;
          %  makes first version of smoothing window plot
%
%  Now do reconstruction pushbutton
ramcbs2 = ['fvfilestr = [FEATMPATH INFILESTR ''.mat''] ;' ...  
           'eval([''load '' fvfilestr]) ;' ...
           'vsmoo = 1 - phi(((0:NMAX) - SMOMEAN) / SMOSD) ;' ...
           'vmask = [] ;' ...
           'for n = 0:NMAX ;' ...
           '  nterm = n + 1 ;' ...
           '  vmask = [vmask; vsmoo(n+1) * ones(nterm,1)] ;'...
           'end ;' ...
           'betahat = betahat .* vmask ;' ...
           'coazrec(betahat) ;' ...
           '    titstr = [''Smoothed Zernikes for '' INFILESTR] ;' ...
           '  title(titstr) ;' ...
           '    tx = -R0 - .10 * (2 * R0) ;' ...
           '    ty = R0 - .06 * (2 * R0) ;' ...
           '  text(tx,ty,[''mu = '' num2str(SMOMEAN)]) ;' ...
           '    tx = R0 - .26 * (2 * R0) ;' ...
           '  text(tx,ty,[''sd = '' num2str(SMOSD)]) ;'] ;
          %  Callback String for smoothed reconstruction
          %    vsmoo  -  vector of smoothing weights
          %                 (one for each frequency)
          %    vmask -  vector of "weights" for coefficients
          %                 (same size as full feature vector)
          %    neven - index of blocks of even and odd frequencies
          %    i0freq -  index (in RAMVCIND scheme) of 0 freq coeff
ramb2hand = uicontrol(RAMHAND,'Style','push','Position',[390 210 99 20],...
              'String','Smooth Recon',...
              'CallBack',ramcbs2) ;
line2hand = uicontrol(RAMHAND,'Style','text',...
            'Position',[0 196 490 2],...
            'BackgroundColor', [0 0 .5]) ;
           %  Create line between simple recon, and smoothed recon



%  Create Environment for Chosen Reconstruction
%
%  Starting with array of pushbuttons for the coefficients
RAMCBHAND = [] ;    %  initialize handles for small checkboxes
RAMVCIND = [] ;     %  initialize values for small checkboxes
i = 0 ;    %  Index when coefficients grouped into a vector
for n = 0:NMAX ;   %  loop through Zernike columns (Jacobi orders)
  if n/2 == round(n/2) ;    %  for n even
    mstart = 0 ;   %  start at 0-th Fourier frequency
  else ;                    %  for n odd
    mstart = 1 ;   %  start at 1-st Fourier frequency
  end ;
  mend = n ;   %  end at n-th Fourier frequency

  for m = mstart:2:mend ;    %  Loop through Fourier frequencies
    i = i + 1 ;
    RAMVCIND = [RAMVCIND; 0] ;    %  Initialize everything to 0
    tempcbstr = ['RAMVCIND(' num2str(i) ') = get(RAMCBHAND(' num2str(i) ...
                      '),''Value'') ;'] ;
          %  CallBack String: when a box is checked/unchecked, update 
          %          vector of indicators for that coefficient
    temphand = uicontrol(RAMHAND,'Style','checkbox',...
              'Position',[(pleft+n*pxjump) (ptop-m*pyjump) pxjump+4 pyjump],...
              'String',[num2str(m) ',' num2str(n)],...
              'CallBack',tempcbstr) ;
          %  String puts coefficient label on checkbox
    RAMCBHAND = [RAMCBHAND; temphand] ;
          %  build up vector of handles, because these are
          %         referenced when a box is checked
  end ;
end ;
%
%  Now do chosen reconstruction pushbutton
ramcbs3 = 'zchoose' ;
	%  call function zchoose (too long for callback string)
	%  makes reconstruction for chosen coefficients

ramb3hand = uicontrol(RAMHAND,'Style','push',...
              'Position',[390 160 99 20],...
              'String','Chosen Recon',...
              'CallBack',ramcbs3) ;




%  Now do power display pushbutton
%
ramcbs4 = ['fvfilestr = [FEATMPATH INFILESTR ''.mat''] ;' ...  
           'eval([''load '' fvfilestr]) ;' ...
           'coazpmap(betahat) ;'] ;
	%  loads current Zernike file, and calls coazmap,
        %  which makes gray level map of log10(power)
ramb4hand = uicontrol(RAMHAND,'Style','push',...
              'Position',[390 60 99 20],...
              'String','Power Display',...
              'CallBack',ramcbs4) ;




