disp('Cornean: Cornea Topography Analysis System, ver. 1.0') ;
disp('(c) J. S. Marron and N. Locantore, 1998') ;
disp('Department of Statistics, University of North Carolina') ;
disp(' ') ;
%
%    This generates main control menu of Cornean
%    Cornea Topography Analysis System,
%      for Analysis of Data Generated by the Keratron 2000
%    This system performs tasks including display of an image,
%      decomposition into Zernike feature matrices,
%      and analyis of populations of feature matrices
%

%%=====================================================================
%%  This should take care of the jockeying back and forth 
%%  between the PC and UNIX environment, and differences in 
%%  paths for users.

global R0 NMAX MATLABVER;
	% R0, Maximum radius and NMAX, maximum zernike order for analysis
        % MATLABVER, version of MATLAB, 4 or 5
global INFILESTR RFILESUF HFILESUF CFILESUF;
global RISTR HISTR CISTR INDATPATH FEATMPATH;
global MMHANDPOS DDMHANDPOS RAMHANDPOS RDHANDPOS PMAPHANDPOS;
	% Figure window positioning handles

ipath = 3;	%%  1 -- denotes file path for Marron
		%%  2 -- denotes file path for Locantore
		%%  3 -- denotes file path for large memory PC
		%%  more here as necessary

imonitor = 3;	%%  1 -- denotes monitor for 13" PC, with Matlab 4
		%%  2 -- denotes monitor for Sun Workstation, Matlab 4
                %%  3 -- denotes monitor for 13" PC, with Matlab 5
		%%  more here as necessary      
      
%%=====================================================================

if ipath == 1;   % file path for Marron's PC's
%  General globals
	NMAX = 5 ;
          %  maximum order of Zernikes to use
	R0 = 4.2 ;
          %  radius of analysis
          %    these get reloaded when a feature vec is reloaded from file

	INFILESTR = '000121_2' ;    
          %  default file name for input         
          %  Favorites are:  000121_2   (good standard Kerataconus)
          %                  000084_1   (central Kerataconus)
          %                  000053_1   (PRK big red ring)
          %                  000139_2   (PRK, wide ring, so thin outer boundary)
          %                  000006_1   (Normal)
	RFILESUF = '.xla' ;
          %  radii data file suffix 
	HFILESUF = '.zla' ;
          %  height data file suffix
	CFILESUF = '.tla' ;
          %  curvature data file suffix

	global INDATPATH FEATMPATH ;
	INDATPATH = 'c:\matlab\cornean\indata\' ;
          %  path for input Keratron files
	FEATMPATH = 'c:\matlab\cornean\zfm\' ;
          %  path for storing Zernike feature matrices

        setpathstr = [...
	'RISTR = [INDATPATH INFILESTR RFILESUF] ;', ...
	'HISTR = [INDATPATH INFILESTR HFILESUF] ;', ...
	'CISTR = [INDATPATH INFILESTR CFILESUF] ;'] ;
          %  Set full filenames




%%--------------------------------------------------------------------

elseif ipath == 2;   % file path for Locantore's Unix
%  General globals
	NMAX = 8 ;
  	  %  maximum number of Zernikes to use	
	R0 = 4.2 ;
          %  radius of analysis
          %    these get reloaded when a feature vec is reloaded from file

	INFILESTR = '1212' ;   
          %  default file name for input   
	RFILESUF = 'xla' ;
          %  radii data file suffix 
   	HFILESUF = 'zla' ;
          %  height data file suffix
   	CFILESUF = 'tla' ;
          %  curvature data file suffix

	global INDATPATH FEATMPATH ;
	INDATPATH = '/home/Mickey/students/tzhang/project/corneal/dat/' ;
          %  path for input Keratron files
	FEATMPATH = '/home/Mickey/students/locantor/cornean/zfm/' ;
          %  path for storing Zernike feature matrices

        setpathstr = [...
	'RISTR = [INDATPATH RFILESUF INFILESTR ''.dat''] ;', ...
	'HISTR = [INDATPATH HFILESUF INFILESTR ''.dat''] ;', ...
	'CISTR = [INDATPATH CFILESUF INFILESTR ''.dat''] ;'] ;
          %  Set full filenames

%%--------------------------------------------------------------------

elseif ipath == 3;   % file path for large memory PC
%  General globals
	NMAX = 8 ;
  	  %  maximum number of Zernikes to use	
	R0 = 4.2 ;
          %  radius of analysis
          %    these get reloaded when a feature vec is reloaded from file

	INFILESTR = '000121_2' ;    
          %  default file name for input         
          %  Favorites are:  000121_2   (good standard Kerataconus)
          %                  000084_1   (central Kerataconus)
          %                  000053_1   (PRK big red ring)
          %                  000139_2   (PRK, wide ring, so thin outer boundary)
          %                  000006_1   (Normal)
	RFILESUF = '.xla' ;
          %  radii data file suffix 
	HFILESUF = '.zla' ;
          %  height data file suffix
	CFILESUF = '.tla' ;
          %  curvature data file suffix

	global INDATPATH FEATMPATH ;
	INDATPATH = 'c:\matlab\cornean\indata\' ;
          %  path for input Keratron files
	FEATMPATH = 'c:\matlab\cornean\zfm\' ;
          %  path for storing Zernike feature matrices

        setpathstr = [...
	'RISTR = [INDATPATH INFILESTR RFILESUF] ;', ...
	'HISTR = [INDATPATH INFILESTR HFILESUF] ;', ...
	'CISTR = [INDATPATH INFILESTR CFILESUF] ;'] ;
          %  Set full filenames

	end;

eval(setpathstr) ;

%%=====================================================================

if imonitor == 1;
	MMHANDPOS   = [10,240,300,260] ;
	DDMHANDPOS  = [50,200,300,200] ;
	RAMHANDPOS  = [90,20,490,340];
	RDHANDPOS   = [400,200,200,200] ; 
	PMAPHANDPOS = [20,20,120,80];
        MATLABVER = 4 ;

elseif imonitor == 2;
	MMHANDPOS   = [10,650,300,260] ;
	DDMHANDPOS  = [10,420,300,160] ;
	RAMHANDPOS  = [10,220,490,340];
	RDHANDPOS   = [330,650,250,250] ; 
	PMAPHANDPOS = [600,650,200,200];
        MATLABVER = 4 ;
   
elseif imonitor == 3;
	MMHANDPOS   = [10,180,300,260] ;
	DDMHANDPOS  = [50,200,300,200] ;
	RAMHANDPOS  = [90,20,490,340];
	RDHANDPOS   = [400,200,200,200] ; 
	PMAPHANDPOS = [20,20,120,80];
        MATLABVER = 5 ;
	end;

%%=====================================================================


%  Set up global variables
%
%  First some general globals
global RAMVCIND SMOMEAN SMOSD ;
%  RAMVCIND - Vector of indicators for coefficients in our out,
%                      in manually driven reconstruction
%  SMOMEAN - mean for smoothed reconstruction
%  SMOSD - standard deviation for smoothed reconstruction

%  Next the globals for handles to figure windows and plots
global MMHAND DDMHAND RAMHAND RAMCBHAND RAMSL1HAND RAMSL2HAND RAMSAXHAND ;
%  MMHAND - handle for Figure Window with Main Menu
%  DDMHAND - handle for Figure Window with Display, Decomposition Menu
%  RAMHAND - handle for Figure Window with Reconstruct, Analyze Menu
%  RAMCBHAND - handle for CheckBoxes in Reconstruct, Analyze Menu
%  RAMSL1HAND - handle for Slider for Mean of smooths
%                              in Reconstruct, Analyze Menu
%  RAMSL2HAND - handle for Slider for sd of smooths
%                              in Reconstruct, Analyze Menu
%  RAMSAXHAND - handle for SmoothDemo Axis, in Reconstruct, Analyze Menu



%  Set Main Menu window and basics
%
if isempty(MMHAND) ;    %  then Main Menu is not up yet, so:
  MMHAND = figure ;
          %  Create a new window for Main Menu
else ;               %  then already have Main Menu up, so make it current
  figure(MMHAND) ;
end ;
clf ;
set(MMHAND,'Position', MMHANDPOS) ;
set(MMHAND, 'NumberTitle', 'off') ; 
set(MMHAND,'Name','Cornean: Main Menu');

%  Create header text
%
mmhhand = uicontrol(MMHAND,'Style','text','Position',[10 230 280 16],...
            'String','Corneal Topography Analysis System', ...	   
 	    'BackgroundColor', [0 0 0], ...
 	    'ForegroundColor', [0 1 1]);

mmhhand2 = uicontrol(MMHAND, 'Style','text','Position',[10 214 280 16],...
            'String','(c) J.S.Marron, N.Locantore, 1998', ...	   
 	    'BackgroundColor', [0 0 0], ...
 	    'ForegroundColor', [0 1 1]);

mmhhand3 = uicontrol(MMHAND, 'Style','text','Position',[10 198 280 16],...
            'String','University of North Carolina, Chapel Hill', ...	   
 	    'BackgroundColor', [0 0 0], ...
 	    'ForegroundColor', [0 1 1]);

%  Create Editable text, for entering input Keratron data filename prefix
%
t1s = 'Keratron Data File Prefix:' ;
          %  text to display in front of entry field
mmthand = uicontrol(MMHAND,'Style','text','Position',[10 145 188 20],...
              'String',t1s) ;
          %  Creation of text on Main menu, in front of entry field
mmethand = uicontrol(MMHAND,'Style','Edit',...
                    'String',INFILESTR,...
                    'Position',[200 145 70 19],...
                    'CallBack',['INFILESTR = get(mmethand,''String'') ;',...
                    'eval(setpathstr) ;']) ;
          %  User types text into window, and then global variable
          %  "INFILESTR" contains string with filename
          %  Note: "String" is just a starting default, known to be there




%  Create push button for Create Display / Decompose Menu
%
mmcbs1 = 'coaddm' ;
          %  Main Menu CallBack String 1: calls coaddm.m
mmb1hand = uicontrol(MMHAND,'Style','push',...
              'Position',[40 105 220 20],...
              'String','Go to Display / Decompose Menu',...
              'CallBack',mmcbs1) ;



%  Create push button for Create Reconstruct Analyze Menu
%
mmcbs2 = 'coaram' ;
          %  Main Menu CallBack String 2: calls coaram.m
mmb2hand = uicontrol(MMHAND,'Style','push',...
              'Position',[40 75 220 20],...
              'String','Go to Reconstruct / Analyze Menu',...
              'CallBack',mmcbs2) ;



%  Create push button for Create Principle Component Analysis Menu
%
mmcbs3 = ['disp(''  This will create ' ...
                'Principle Component Analysis Menu'')'] ;
          %  Main Menu CallBack String 3:
          %          Create Principle Component Analysis Menu
mmb3hand = uicontrol(MMHAND,'Style','push',...
              	'Position',[40 45 220 20],...
              	'String','Go to Principle Component Menu',...
                'CallBack',mmcbs3) ;


%  have room for two more such buttons, 
%        at [40 35 220 20] and [40 5 220 20]


