function coaipcap
% COAIPCAP, Does print of Individual in Principal Component Analysis
%      Corneal Topography Analysis System
%   Creates a color postscript file, of
%   large size window with one page Indiv. in PCA
%      Intended to be called by coaipm.m
% Outputs:
%     Postscript file in directory ~cornean\outputs

%    Copyright (c) J. S. Marron 1998
%    Department of Statistics, University of North Carolina




%  Set up global variables
%
global IPCAHAND LISTFILESTR INFILESTR ;
%  IPCAHAND - handle for Static PCA Window
%  LISTFILESTR - Input list file name
%  INFILESTR - string with input filename




if isempty(IPCAHAND) ;
        %  then IPCA window not yet created,
        %  so give error message

  disp('   ') ;
  disp('!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!') ;
  disp('!!!   Can''t print Individual PCA plot,') ;
  disp('!!!   Since Analysis not done yet') ;
  disp('!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!') ;

else ;  %  then have done the analysis, so print result

  figure(IPCAHAND) ;

  orient landscape ;
  eval(['print outputs\' LISTFILESTR INFILESTR '.ps -dpsc']) ;

  disp('  Finsished Creating Postscript file for ') ;
  disp(['    Individual ' INFILESTR ' among list file: ' LISTFILESTR]) ;

end ;
