function coams
% COAMS, Does save of Difference Analysis Movies
%                (formerly called "Morphing Analysis")
%      Corneal Topography Analysis System
%   Creates an MPEG file, of window with movie
%      Intended to be called by coamam.m
% Outputs:
%     MPEG file in directory ~cornean\outputs

%    Copyright (c) J. S. Marron 1998
%    Department of Statistics, University of North Carolina


%  Set up global variables
%
global COMAP ;
%  COMAP - Color Map
global M1FILESTR M2FILESTR M3FILESTR ;
          %  Strings with movie feature vector files
global MAMOVHAND MAM;
%  MAMOVHAND - Movie Window handle
%  MAM - name of the movie matrix




%  Set up mpeg parameters
%
%vopt = [10] ;      %  Need to twiddle these, when have player working
%
%  This is MATLAB "help" to use for choosing parameters:
%	MPGWRITE(M, map, 'filename', options) Encodes M in MPEG format
% 	using the specified colormap and writes the result to the
% 	specified file.  The options argument is an optional vector of
% 	8 or fewer options where each value has the following meaning:
% 	1. REPEAT:
% 		An integer number of times to repeat the movie
% 		(default is 1).
% 	2. P-SEARCH ALGORITHM:
% 		0 = logarithmic	(fastest, default value)
% 		1 = subsample
% 		2 = exhaustive	(better, but slow)
% 	3. B-SEARCH ALGORITHM:
% 		0 = simple	(fastest)
% 		1 = cross2	(slightly slower, default value)
% 		2 = exhaustive	(very slow)
% 	4. REFERENCE FRAME:
% 		0 = original	(faster, default)
% 		1 = decoded	(slower, but results in better quality)
% 	5. RANGE IN PIXELS:
% 		An integer search radius.  Default is 10.
% 	6. I-FRAME Q-SCALE:
% 		An integer between 1 and 31.  Default is 8.
% 	7. P-FRAME Q-SCALE:
% 		An integer between 1 and 31.  Default is 10.
% 	8. B-FRAME Q-SCALE:
% 		An integer between 1 and 31.  Default is 25.
 



if isempty(MAM) ;
        %  then difference analysis movie not yet created,
        %  so give error message

  disp('   ') ;
  disp('!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!') ;
  disp('!!!   Can''t save Difference Analysis movie,') ;
  disp('!!!   Since it hasn''t been made yet') ;
  disp('!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!') ;

else ;  %  then have done the analysis, so print result

  outstr = ['outputs\' M1FILESTR 'd' M2FILESTR '.mpg'] ;
  mpgwrite(MAM,COMAP,outstr) ;
%  mpgwrite(MAM,COMAP,outstr,vopt) ;

  disp('  Finished saving MPEG movie file for ') ;
  disp(['    difference analysis of file: ' M1FILESTR]) ;
  disp(['                           with: ' M2FILESTR]) ;
  disp('        Caution: actual MPEG file is created') ;
  disp('                   only after leaving MATLAB') ;

end ;
