function subdir(dirstr) 
% SUBDIR, 
% Input:
%     dirstr - string containing a full directory
% Output:
%       Writes subdirectories to screen

%    Copyright (c) J. S. Marron 1998


dirstruct = dir(dirstr) ;
nstruct = size(dirstruct,1) ;

if nstruct > 0 ;    %  then typed in a valid directory

  disp(['Subdirectories of ' dirstr ' are:']) ;

  for istruct = 3:nstruct ;  %  loop though entries of directory

    if dirstruct(istruct).isdir == 1 ;  %  then the current entry
                                        %  is the name of a subdirectory

      disp(['        ' dirstruct(istruct).name ]) ;

    end ;

  end ;

else ;     %  then entered directory is not valid

  disp('!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!') ;
  disp('!!!   Error from subdir.m:                !!!') ;
  disp('!!!   Entered string is not a directory   !!!') ;
  disp('!!!   Not listing subdirectories          !!!') ;
  disp('!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!') ;

end ;


