function [ht, dht, ddht] = zrecon(coefs, order, rgrid, angrid, rmax)
% ZRECON, returns a vector of fitted coefficients for a given
%	grid of radii and angles
%
% Inputs -
%	coefs 	- the Zernike coefficients from a particular fit
%	order	- maximal order of Zernike fitting
%	rgrid	- given input grid of radius values
%	angrid	- given grid of angular values
%	rmax	- maximum radius of interest
% Output -
%	ht	- Zernike height mapping for reconstruction
%	dht	- first radial derivative mapping
%	ddht	- second radial derivative mapping
%
%  Coded by N.Locantore, 1/7/98.

rgrid = rgrid(:);
angrid = angrid(:);

design 	= zernike(order, rmax, rgrid, angrid); 	% make Zernikes for grid
ht	= design * coefs;			% fit using existing coefs
clear design;

ddesign = dzernike(order, rmax, rgrid, angrid);	% first derivative grid
dht	= ddesign * coefs;
clear ddesign;

dddesign = ddzernik(order, rmax, rgrid, angrid);  % second derivative grid
ddht	= dddesign * coefs;
clear dddesign;

