%%*********************************************************
%% Atyfun: compute sum_{k=1}^m yk*Ak. 
%%
%%  Q = Atyfun(blk,Avec,permA,isspAy,y);
%%
%% SDPT3: version 3.0
%% Copyright (c) 1997 by
%% K.C. Toh, M.J. Todd, R.H. Tutuncu
%% Last modified: 2 Feb 01
%%**********************************************************

  function Q = Atyfun(blk,Avec,permA,isspAy,y);

  if ~iscell(Avec)
     if strcmp(blk{1},'s') 
        Q = smat(blk,Avec*y(permA,1),isspAy);
     else
        Q = Avec*y; 
     end
  else
     Q = cell(size(blk,1),1); 
     for p = 1:size(blk,1)
        pblk = blk(p,:);
        if strcmp(pblk{1},'s')
           tmp = Avec{p}*y(permA(p,:),1); 
           Q{p} = smat(pblk,tmp,isspAy(p)); 
	else
           Q{p} = Avec{p}*y; 
        end 
     end
  end 
%%********************************************************* 

