%%********************************************************************
%% checkdense : identify the dense columns of a matrix
%%           
%%              adapted from a file in LIPSOL by Yin Zhang
%%
%% SDPT3: version 
%% Copyright (c) 1997 by
%% K.C. Toh, M.J. Todd, R.H. Tutuncu
%% Last Modified: 2 Feb 01
%%********************************************************************

  function  [idense,isparse] = checkdense(A);

     m = size(A,1);
     idense = []; 
     isparse = []; 
     nzratio = 1;
     if (m >  500) nzratio = 0.20; end;
     if (m > 1000) nzratio = 0.10; end;
     if (m > 5000) nzratio = 0.05; end;
     if (nzratio < 1)
        checking = (sum(spones(A))/m <= nzratio);
        if any(checking == 0)
           idense = find(sparse(1-checking));   % Dense column indices
   	   isparse = find(checking); 
        end
        clear checking;
     end
%%
%%********************************************************************
