%*********************************************************
%% svec: compute the vector svec(M),
%%
%%   x = svec(blk,M,isspx);
%%
%% SDPT3: version 3.0
%% Copyright (c) 1997 by
%% K.C. Toh, M.J. Todd, R.H. Tutuncu
%% Last modified: 2 Feb 01
%%**********************************************************

  function x = svec(blk,M,isspx); 
     
   if iscell(M) 
      if (nargin == 2)
         if (size(M,2) == 1); 
            isspx = zeros(size(blk,1),1); 
         else 
            isspx = ones(size(blk,1),1); 
         end
      else
         if (length(isspx) < size(blk,1)); 
            isspx = ones(size(blk,1),1); 
         end
      end;
      x = cell(size(blk,1),1); 
      for p=1:size(blk,1)
         pblk = blk(p,:);  
         n = sum(pblk{2});  m = size(M,2); 
         if strcmp(pblk{1},'s')
            n2 = sum(pblk{2}.*(pblk{2}+1))/2; 
            if (isspx(p)); 
               x{p} = sparse(n2,m); 
            else 
               x{p} = zeros(n2,m); 
            end
            numblk = length(pblk{2}); 
            for k = 1:m;
               if (numblk > 1) & ~issparse(M{p,k});
                  x{p}(:,k) = mexsvec(pblk,sparse(M{p,k}),isspx(p)); 
               else
                  x{p}(:,k) = mexsvec(pblk,M{p,k},isspx(p)); 
               end
            end
	 elseif (strcmp(pblk{1},'q') | strcmp(pblk{1},'l'));
            if (isspx(p)); 
               x{p} = sparse(n,m); 
            else 
               x{p} = zeros(n,m); 
            end
            for k = 1:m; 
                x{p}(:,k) = M{p,k};
            end
         end
      end
   else 
      if (nargin == 2); isspx = 0; end
      if strcmp(blk{1},'s')
         x = mexsvec(blk,M,isspx); 
      elseif (strcmp(blk{1},'q') | strcmp(blk{1},'l')); 
         x = M;
      end
   end; 
%%**********************************************************   

