%%*********************************************************
%% AXfun: compute AX(k) = <Ak,X>, k = 1:m
%%
%%   AX = AXfun(blk,Avec,permA,X);
%%
%% SDPT3: version 3.0
%% Copyright (c) 1997 by
%% K.C. Toh, M.J. Todd, R.H. Tutuncu
%% Last modified: 2 Feb 01
%%**********************************************************

  function AX = AXfun(blk,Avec,permA,X);

  m = size(permA,2); 
  AX = zeros(m,1);  
  for p = 1:size(blk,1); 
     pblk = blk(p,:);
     if strcmp(pblk{1},'s'); 
        tmp(permA(p,:),1) = (svec(pblk,X{p})'*Avec{p})'; 
        %%not advisable to use the expression below.
        %%tmp(permA(p,:),1) = mexinprod(blk,Avec,svec(pblk,X{p}),m,p); 
        AX = AX + tmp;
     else
        AX = AX + (X{p}'*Avec{p})'; 
     end
  end
%%*********************************************************
