%%******************************************************************
%% blkchol: compute Cholesky factorization of X. 
%%          
%%  [Xchol,indef] = blkchol(blk,X); 
%%  
%%  X = Xchol'*Xchol;
%%
%% SDPT3: version 3.0
%% Copyright (c) 1997 by
%% K.C. Toh, M.J. Todd, R.H. Tutuncu
%% Last Modified: 2 Feb 01
%%******************************************************************
 

  function [Xchol,indef] = blkchol(blk,X,permX); 

  if nargin == 2; permX = []; end;
  if ~iscell(X); 
     n = length(X); 
     if strcmp(blk{1},'s');
        if isempty(permX) | ~issparse(X); 
           [Xchol,indef] = chol(X); 
        else
           [tmp,indef] = chol(X(permX,permX)); 
           Xchol(:,permX) = tmp; 
        end
     elseif strcmp(blk{1},'q') 
        gamx = mexqops(blk,X,X,2); 
        if any(gamx <= 0) 
           indef = 1; 
        else
           indef = 0; 
        end
        Xchol = [];   
     elseif strcmp(blk{1},'l'); 
        if any(X <= 0); 
           indef = 1; 
        else;
           indef = 0; 
        end; 
        Xchol = [];  
     end; 
  else; 
     Xchol = cell(size(X));  
     for p = 1:size(blk,1); 
        [Xchol{p},indef(p)] = blkchol(blk(p,:),X{p});
     end;
     indef = max(indef); 
  end; 
%%=================================================================      


