/* blkfct.f -- translated by f2c (version of 23 April 1993  18:34:30).
   You must link the resulting object file with the libraries:
	-lf2c -lm   (in that order)
*/

typedef int integer;
typedef double doublereal;
typedef /* Subroutine */ int (*S_fp)();
typedef /* Unknown type of function */ int (*U_fp)();

#if !defined(min)
#define  min(A, B)   ((A) < (B) ? (A) : (B))
#endif
#if !defined(max)
#define  max(A, B)   ((A) > (B) ? (A) : (B))
#endif

/* *********************************************************************** */
/* *********************************************************************** */

/*   Version:        0.3 */
/*   Last modified:  March 6, 1995 */
/*   Authors:        Esmond G. Ng and Barry W. Peyton */

/*   Mathematical Sciences Section, Oak Ridge National Laboratory */

/* *********************************************************************** */
/* *********************************************************************** */
/* *********     BLKFCT .....  BLOCK GENERAL SPARSE CHOLESKY     ********* */
/* *********************************************************************** */
/* *********************************************************************** */

/*   PURPOSE: */
/*       THIS SUBROUTINE CALLS THE BLOCK GENERAL SPARSE CHOLESKY ROUTINE, */
/*       BLKFC2. */

/*   INPUT PARAMETERS: */
/*       NSUPER          -   NUMBER OF SUPERNODES. */
/*       XSUPER          -   SUPERNODE PARTITION. */
/*       SNODE           -   MAPS EACH COLUMN TO THE SUPERNODE CONTAINING */
/*                           IT. */
/*       SPLIT           -   SPLITTING OF SUPERNODES SO THAT THEY FIT */
/*                           INTO CACHE. */
/*       (XLINDX,LINDX)  -   ROW INDICES FOR EACH SUPERNODE (INCLUDING */
/*                           THE DIAGONAL ELEMENTS). */
/*       (XLNZ,LNZ)      -   ON INPUT, CONTAINS MATRIX TO BE FACTORED. */
/*       IWSIZ           -   SIZE OF INTEGER WORKING STORAGE */
/*       TMPSIZ          -   SIZE OF FLOATING POINT WORKING STORAGE. */
/*       MMPYN           -   EXTERNAL ROUTINE: MATRIX-MATRIX MULTIPLY. */
/*       SMXPY           -   EXTERNAL ROUTINE: MATRIX-VECTOR MULTIPLY. */

/*   OUTPUT PARAMETERS: */
/*       LNZ             -   ON OUTPUT, CONTAINS CHOLESKY FACTOR. */
/*       IFLAG           -   ERROR FLAG. */
/*                               0: SUCCESSFUL FACTORIZATION. */
/*                              -1: NONPOSITIVE DIAGONAL ENCOUNTERED, */
/*                                  MATRIX IS NOT POSITIVE DEFINITE. */
/*                              -2: INSUFFICIENT WORKING STORAGE */
/*                                  [TEMP(*)]. */
/*                              -3: INSUFFICIENT WORKING STORAGE */
/*                                  [IWORK(*)]. */

/*   WORKING PARAMETERS: */
/*       IWORK           -   INTEGER WORKING STORAGE OF LENGTH */
/*                           2*NEQNS + 2*NSUPER. */
/*       TMPVEC          -   DOUBLE PRECISION WORKING STORAGE OF LENGTH */
/*                           NEQNS. */

/* *********************************************************************** */

/* Subroutine */ int blkfct_(integer *neqns, integer *nsuper, integer *xsuper,
	 integer *snode, integer *split, integer *xlindx, integer *lindx, 
	integer *xlnz, doublereal *lnz, integer *iwsiz, integer *iwork, 
	integer *tmpsiz, doublereal *tmpvec, integer *iflag, U_fp mmpyn, U_fp 
	smxpy)
{
    extern /* Subroutine */ int blkfc2_(integer *, integer *, integer *, 
	    integer *, integer *, integer *, integer *, doublereal *, integer 
	    *, integer *, integer *, integer *, integer *, doublereal *, 
	    integer *, U_fp, U_fp);


/* ***********************************************************************
 */

/*       ----------- */
/*       PARAMETERS. */
/*       ----------- */


/* ********************************************************************* 
*/

    /* Parameter adjustments */
    --tmpvec;
    --iwork;
    --lnz;
    --xlnz;
    --lindx;
    --xlindx;
    --split;
    --snode;
    --xsuper;

    /* Function Body */
    *iflag = 0;
    if (*iwsiz < (*neqns << 1) + (*nsuper << 1)) {
	*iflag = -3;
	return 0;
    }
    blkfc2_(nsuper, &xsuper[1], &snode[1], &split[1], &xlindx[1], &lindx[1], &
	    xlnz[1], &lnz[1], &iwork[1], &iwork[*nsuper + 1], &iwork[(*nsuper 
	    << 1) + 1], &iwork[(*nsuper << 1) + *neqns + 1], tmpsiz, &tmpvec[
	    1], iflag, (U_fp)mmpyn, (U_fp)smxpy);
    return 0;
} /* blkfct_ */

/* *********************************************************************** */
/* *********************************************************************** */

/*   Version:        0.3 */
/*   Last modified:  March 6, 1995 */
/*   Authors:        Esmond G. Ng and Barry W. Peyton */

/*   Mathematical Sciences Section, Oak Ridge National Laboratory */

/* *********************************************************************** */
/* *********************************************************************** */
/* *********     BLKFC2 .....  BLOCK GENERAL SPARSE CHOLESKY     ********* */
/* *********************************************************************** */
/* *********************************************************************** */

/*   PURPOSE: */
/*       THIS SUBROUTINE FACTORS A SPARSE POSITIVE DEFINITE MATRIX. */
/*       THE COMPUTATION IS ORGANIZED AROUND KERNELS THAT PERFORM */
/*       SUPERNODE-TO-SUPERNODE UPDATES, I.E., BLOCK-TO-BLOCK UPDATES. */

/*   INPUT PARAMETERS: */
/*       NSUPER          -   NUMBER OF SUPERNODES. */
/*       XSUPER          -   SUPERNODE PARTITION. */
/*       SNODE           -   MAPS EACH COLUMN TO THE SUPERNODE CONTAINING */
/*                           IT. */
/*       SPLIT           -   SPLITTING OF SUPERNODES SO THAT THEY FIT */
/*                           INTO CACHE. */
/*       (XLINDX,LINDX)  -   ROW INDICES FOR EACH SUPERNODE (INCLUDING */
/*                           THE DIAGONAL ELEMENTS). */
/*       (XLNZ,LNZ)      -   ON INPUT, CONTAINS MATRIX TO BE FACTORED. */
/*       TMPSIZ          -   SIZE OF TEMPORARY WORKING STORAGE. */
/*       MMPYN           -   EXTERNAL ROUTINE: MATRIX-MATRIX MULTIPLY. */
/*       SMXPY           -   EXTERNAL ROUTINE: MATRIX-VECTOR MULTIPLY. */

/*   OUTPUT PARAMETERS: */
/*       LNZ             -   ON OUTPUT, CONTAINS CHOLESKY FACTOR. */
/*       IFLAG           -   ERROR FLAG. */
/*                               0: SUCCESSFUL FACTORIZATION. */
/*                              -1: NONPOSITIVE DIAGONAL ENCOUNTERED, */
/*                                  MATRIX IS NOT POSITIVE DEFINITE. */
/*                              -2: INSUFFICIENT WORKING STORAGE */
/*                                  [TEMP(*)]. */

/*   WORKING PARAMETERS: */
/*       LINK            -   LINKS TOGETHER THE SUPERNODES IN A SUPERNODE */
/*                           ROW. */
/*       LENGTH          -   LENGTH OF THE ACTIVE PORTION OF EACH */
/*                           SUPERNODE. */
/*       INDMAP          -   VECTOR OF SIZE NEQNS INTO WHICH THE GLOBAL */
/*                           INDICES ARE SCATTERED. */
/*       RELIND          -   MAPS LOCATIONS IN THE UPDATING COLUMNS TO */
/*                           THE CORRESPONDING LOCATIONS IN THE UPDATED */
/*                           COLUMNS.  (RELIND IS GATHERED FROM INDMAP). */
/*       TEMP            -   REAL VECTOR FOR ACCUMULATING UPDATES.  MUST */
/*                           ACCOMODATE ALL COLUMNS OF A SUPERNODE. */

/* *********************************************************************** */

/* Subroutine */ int blkfc2_(integer *nsuper, integer *xsuper, integer *snode,
	 integer *split, integer *xlindx, integer *lindx, integer *xlnz, 
	doublereal *lnz, integer *link, integer *length, integer *indmap, 
	integer *relind, integer *tmpsiz, doublereal *temp, integer *iflag, 
	U_fp mmpyn, U_fp smxpy)
{
    /* System generated locals */
    integer i__1, i__2;

    /* Local variables */
    static integer ilen, jlen, klen, jsup, ksup;
    extern /* Subroutine */ int mmpy_(integer *, integer *, integer *, 
	    integer *, integer *, doublereal *, doublereal *, integer *, U_fp)
	    ;
    static integer i, fjcol, fkcol, ljcol;
    extern /* Subroutine */ int assmb_(integer *, integer *, doublereal *, 
	    integer *, integer *, doublereal *, integer *);
    static integer klast, ilpnt, jlpnt, klpnt, store;
    extern /* Subroutine */ int mmpyi_(integer *, integer *, integer *, 
	    doublereal *, integer *, doublereal *, integer *);
    static integer jxpnt, kxpnt, inddif;
    extern /* Subroutine */ int igathr_(integer *, integer *, integer *, 
	    integer *), ldindx_(integer *, integer *, integer *);
    static integer njcols, nkcols;
    extern /* Subroutine */ int chlsup_(integer *, integer *, integer *, 
	    integer *, doublereal *, integer *, U_fp, U_fp);
    static integer ncolup, kfirst, nxtcol, nxksup, nxtsup;


/* ********************************************************************* 
*/

/*       ----------- */
/*       PARAMETERS. */
/*       ----------- */


/*       ---------------- */
/*       LOCAL VARIABLES. */
/*       ---------------- */


/* ********************************************************************* 
*/

    /* Parameter adjustments */
    --temp;
    --relind;
    --indmap;
    --length;
    --link;
    --lnz;
    --xlnz;
    --lindx;
    --xlindx;
    --split;
    --snode;
    --xsuper;

    /* Function Body */
    *iflag = 0;

/*       ----------------------------------------------------------- */
/*       INITIALIZE EMPTY ROW LISTS IN LINK(*) AND ZERO OUT TEMP(*). */
/*       ----------------------------------------------------------- */
    i__1 = *nsuper;
    for (jsup = 1; jsup <= i__1; ++jsup) {
	link[jsup] = 0;
/* L100: */
    }
    i__1 = *tmpsiz;
    for (i = 1; i <= i__1; ++i) {
	temp[i] = 0.;
/* L200: */
    }

/*       --------------------------- */
/*       FOR EACH SUPERNODE JSUP ... */
/*       --------------------------- */
    i__1 = *nsuper;
    for (jsup = 1; jsup <= i__1; ++jsup) {

/*           ------------------------------------------------ */
/*           FJCOL  ...  FIRST COLUMN OF SUPERNODE JSUP. */
/*           LJCOL  ...  LAST COLUMN OF SUPERNODE JSUP. */
/*           NJCOLS ...  NUMBER OF COLUMNS IN SUPERNODE JSUP. */
/*           JLEN   ...  LENGTH OF COLUMN FJCOL. */
/*           JXPNT  ...  POINTER TO INDEX OF FIRST */
/*                       NONZERO IN COLUMN FJCOL. */
/*           ------------------------------------------------ */
	fjcol = xsuper[jsup];
	njcols = xsuper[jsup + 1] - fjcol;
	ljcol = fjcol + njcols - 1;
	jlen = xlnz[fjcol + 1] - xlnz[fjcol];
	jxpnt = xlindx[jsup];

/*           ----------------------------------------------------- */
/*           SET UP INDMAP(*) TO MAP THE ENTRIES IN UPDATE COLUMNS */
/*           TO THEIR CORRESPONDING POSITIONS IN UPDATED COLUMNS, */
/*           RELATIVE THE THE BOTTOM OF EACH UPDATED COLUMN. */
/*           ----------------------------------------------------- */
	ldindx_(&jlen, &lindx[jxpnt], &indmap[1]);

/*           ----------------------------------------- */
/*           FOR EVERY SUPERNODE KSUP IN ROW(JSUP) ... */
/*           ----------------------------------------- */
	ksup = link[jsup];
L300:
	if (ksup > 0) {
	    nxksup = link[ksup];

/*               ------------------------------------------------
------- */
/*               GET INFO ABOUT THE CMOD(JSUP,KSUP) UPDATE. */

/*               FKCOL  ...  FIRST COLUMN OF SUPERNODE KSUP. */
/*               NKCOLS ...  NUMBER OF COLUMNS IN SUPERNODE KSUP. 
*/
/*               KLEN   ...  LENGTH OF ACTIVE PORTION OF COLUMN FK
COL. */
/*               KXPNT  ...  POINTER TO INDEX OF FIRST NONZERO IN 
ACTIVE */
/*                           PORTION OF COLUMN FJCOL. */
/*               ------------------------------------------------
------- */
	    fkcol = xsuper[ksup];
	    nkcols = xsuper[ksup + 1] - fkcol;
	    klen = length[ksup];
	    kxpnt = xlindx[ksup + 1] - klen;

/*               ------------------------------------------- */
/*               PERFORM CMOD(JSUP,KSUP), WITH SPECIAL CASES */
/*               HANDLED DIFFERENTLY. */
/*               ------------------------------------------- */

	    if (klen != jlen) {

/*                   ----------------------------------------
--- */
/*                   SPARSE CMOD(JSUP,KSUP). */

/*                   NCOLUP ... NUMBER OF COLUMNS TO BE UPDATE
D. */
/*                   ----------------------------------------
--- */

		i__2 = klen - 1;
		for (i = 0; i <= i__2; ++i) {
		    nxtcol = lindx[kxpnt + i];
		    if (nxtcol > ljcol) {
			goto L500;
		    }
/* L400: */
		}
		i = klen;
L500:
		ncolup = i;

		if (nkcols == 1) {

/*                       --------------------------------
-------------- */
/*                       UPDATING TARGET SUPERNODE BY TRIV
IAL */
/*                       SUPERNODE (WITH ONE COLUMN). */

/*                       KLPNT  ...  POINTER TO FIRST NONZ
ERO IN ACTIVE */
/*                                   PORTION OF COLUMN FKC
OL. */
/*                       --------------------------------
-------------- */
		    klpnt = xlnz[fkcol + 1] - klen;
		    mmpyi_(&klen, &ncolup, &lindx[kxpnt], &lnz[klpnt], &xlnz[
			    1], &lnz[1], &indmap[1]);

		} else {

/*                       --------------------------------
------------ */
/*                       KFIRST ...  FIRST INDEX OF ACTIVE
 PORTION OF */
/*                                   SUPERNODE KSUP (FIRST
 COLUMN TO */
/*                                   BE UPDATED). */
/*                       KLAST  ...  LAST INDEX OF ACTIVE 
PORTION OF */
/*                                   SUPERNODE KSUP. */
/*                       --------------------------------
------------ */

		    kfirst = lindx[kxpnt];
		    klast = lindx[kxpnt + klen - 1];
		    inddif = indmap[kfirst] - indmap[klast];

		    if (inddif < klen) {

/*                           ------------------------
--------------- */
/*                           DENSE CMOD(JSUP,KSUP). */

/*                           ILPNT  ...  POINTER TO FI
RST NONZERO IN */
/*                                       COLUMN KFIRST
. */
/*                           ILEN   ...  LENGTH OF COL
UMN KFIRST. */
/*                           ------------------------
--------------- */
			ilpnt = xlnz[kfirst];
			ilen = xlnz[kfirst + 1] - ilpnt;
			mmpy_(&klen, &nkcols, &ncolup, &split[fkcol], &xlnz[
				fkcol], &lnz[1], &lnz[ilpnt], &ilen, (U_fp)
				mmpyn);

		    } else {

/*                           ------------------------
------- */
/*                           GENERAL SPARSE CMOD(JSUP,
KSUP). */
/*                           COMPUTE CMOD(JSUP,KSUP) U
PDATE */
/*                           IN WORK STORAGE. */
/*                           ------------------------
------- */
			store = klen * ncolup - ncolup * (ncolup - 1) / 2;
			if (store > *tmpsiz) {
			    *iflag = -2;
			    return 0;
			}
			mmpy_(&klen, &nkcols, &ncolup, &split[fkcol], &xlnz[
				fkcol], &lnz[1], &temp[1], &klen, (U_fp)mmpyn)
				;
/*                           ------------------------
---------------- */
/*                           GATHER INDICES OF KSUP RE
LATIVE TO JSUP. */
/*                           ------------------------
---------------- */
			igathr_(&klen, &lindx[kxpnt], &indmap[1], &relind[1]);
/*                           ------------------------
-------------- */
/*                           INCORPORATE THE CMOD(JSUP
,KSUP) BLOCK */
/*                           UPDATE INTO THE TO APPROP
RIATE COLUMNS */
/*                           OF L. */
/*                           ------------------------
-------------- */
			assmb_(&klen, &ncolup, &temp[1], &relind[1], &xlnz[
				fjcol], &lnz[1], &jlen);

		    }

		}

	    } else {

/*                   ----------------------------------------
------ */
/*                   DENSE CMOD(JSUP,KSUP). */
/*                   JSUP AND KSUP HAVE IDENTICAL STRUCTURE. 
*/

/*                   JLPNT  ...  POINTER TO FIRST NONZERO IN C
OLUMN */
/*                               FJCOL. */
/*                   ----------------------------------------
------ */
		jlpnt = xlnz[fjcol];
		mmpy_(&klen, &nkcols, &njcols, &split[fkcol], &xlnz[fkcol], &
			lnz[1], &lnz[jlpnt], &jlen, (U_fp)mmpyn);
		ncolup = njcols;
		if (klen > njcols) {
		    nxtcol = lindx[jxpnt + njcols];
		}

	    }

/*               ------------------------------------------------ 
*/
/*               LINK KSUP INTO LINKED LIST OF THE NEXT SUPERNODE 
*/
/*               IT WILL UPDATE AND DECREMENT KSUP'S ACTIVE */
/*               LENGTH. */
/*               ------------------------------------------------ 
*/
	    if (klen > ncolup) {
		nxtsup = snode[nxtcol];
		link[ksup] = link[nxtsup];
		link[nxtsup] = ksup;
		length[ksup] = klen - ncolup;
	    } else {
		length[ksup] = 0;
	    }

/*               ------------------------------- */
/*               NEXT UPDATING SUPERNODE (KSUP). */
/*               ------------------------------- */
	    ksup = nxksup;
	    goto L300;

	}

/*           ---------------------------------------------- */
/*           APPLY PARTIAL CHOLESKY TO THE COLUMNS OF JSUP. */
/*           ---------------------------------------------- */
	chlsup_(&jlen, &njcols, &split[fjcol], &xlnz[fjcol], &lnz[1], iflag, (
		U_fp)mmpyn, (U_fp)smxpy);
	if (*iflag != 0) {
	    *iflag = -1;
	    return 0;
	}

/*           ----------------------------------------------- */
/*           INSERT JSUP INTO LINKED LIST OF FIRST SUPERNODE */
/*           IT WILL UPDATE. */
/*           ----------------------------------------------- */
	if (jlen > njcols) {
	    nxtcol = lindx[jxpnt + njcols];
	    nxtsup = snode[nxtcol];
	    link[jsup] = link[nxtsup];
	    link[nxtsup] = jsup;
	    length[jsup] = jlen - njcols;
	} else {
	    length[jsup] = 0;
	}

/* L600: */
    }

    return 0;
} /* blkfc2_ */

/* *********************************************************************** */
/* *********************************************************************** */

/*   Version:        0.3 */
/*   Last modified:  December 27, 1994 */
/*   Authors:        Esmond G. Ng and Barry W. Peyton */

/*   Mathematical Sciences Section, Oak Ridge National Laboratory */

/* *********************************************************************** */
/* *********************************************************************** */
/* ******         LDINDX .... LOAD INDEX VECTOR             ************** */
/* *********************************************************************** */
/* *********************************************************************** */

/*     PURPOSE - THIS ROUTINE COMPUTES THE SECOND INDEX VECTOR */
/*               USED TO IMPLEMENT THE DOUBLY-INDIRECT SAXPY-LIKE */
/*               LOOPS THAT ALLOW US TO ACCUMULATE UPDATE */
/*               COLUMNS DIRECTLY INTO FACTOR STORAGE. */

/*     INPUT PARAMETERS - */
/*        JLEN   - LENGTH OF THE FIRST COLUMN OF THE SUPERNODE, */
/*                 INCLUDING THE DIAGONAL ENTRY. */
/*        LINDX  - THE OFF-DIAGONAL ROW INDICES OF THE SUPERNODE, */
/*                 I.E., THE ROW INDICES OF THE NONZERO ENTRIES */
/*                 LYING BELOW THE DIAGONAL ENTRY OF THE FIRST */
/*                 COLUMN OF THE SUPERNODE. */

/*     OUTPUT PARAMETERS - */
/*        INDMAP - THIS INDEX VECTOR MAPS EVERY GLOBAL ROW INDEX */
/*                 OF NONZERO ENTRIES IN THE FIRST COLUMN OF THE */
/*                 SUPERNODE TO ITS POSITION IN THE INDEX LIST */
/*                 RELATIVE TO THE LAST INDEX IN THE LIST.  MORE */
/*                 PRECISELY, IT GIVES THE DISTANCE OF EACH INDEX */
/*                 FROM THE LAST INDEX IN THE LIST. */

/* *********************************************************************** */

/* Subroutine */ int ldindx_(integer *jlen, integer *lindx, integer *indmap)
{
    /* System generated locals */
    integer i__1;

    /* Local variables */
    static integer jsub, j, curlen;


/* ***********************************************************************
 */

/*     ----------- */
/*     PARAMETERS. */
/*     ----------- */

/*     ---------------- */
/*     LOCAL VARIABLES. */
/*     ---------------- */

/* ***********************************************************************
 */

/* DIR$ IVDEP */
    /* Parameter adjustments */
    --indmap;
    --lindx;

    /* Function Body */
    curlen = *jlen;
    i__1 = *jlen;
    for (j = 1; j <= i__1; ++j) {
	jsub = lindx[j];
	--curlen;
	indmap[jsub] = curlen;
/* L200: */
    }
    return 0;
} /* ldindx_ */

/* *********************************************************************** */
/* *********************************************************************** */

/*   Version:        0.3 */
/*   Last modified:  December 27, 1994 */
/*   Authors:        Esmond G. Ng and Barry W. Peyton */

/*   Mathematical Sciences Section, Oak Ridge National Laboratory */

/* *********************************************************************** */
/* *********************************************************************** */
/* *************     MMPYI  .... MATRIX-MATRIX MULTIPLY     ************** */
/* *********************************************************************** */
/* *********************************************************************** */

/*   PURPOSE - */
/*       THIS ROUTINE PERFORMS A MATRIX-MATRIX MULTIPLY, Y = Y + XA, */
/*       ASSUMING DATA STRUCTURES USED IN SOME OF OUR SPARSE CHOLESKY */
/*       CODES. */

/*       MATRIX X HAS ONLY 1 COLUMN. */

/*   INPUT PARAMETERS - */
/*       M               -   NUMBER OF ROWS IN X AND IN Y. */
/*       Q               -   NUMBER OF COLUMNS IN A AND Y. */
/*       XPNT(*)         -   XPNT(J+1) POINTS ONE LOCATION BEYOND THE */
/*                           END OF THE J-TH COLUMN OF X.  XPNT IS ALSO */
/*                           USED TO ACCESS THE ROWS OF A. */
/*       X(*)            -   CONTAINS THE COLUMNS OF X AND THE ROWS OF A. */
/*       IY(*)           -   IY(COL) POINTS TO THE BEGINNING OF COLUMN */
/*       RELIND(*)       -   RELATIVE INDICES. */

/*   UPDATED PARAMETERS - */
/*       Y(*)            -   ON OUTPUT, Y = Y + AX. */

/* *********************************************************************** */

/* Subroutine */ int mmpyi_(integer *m, integer *q, integer *xpnt, doublereal 
	*x, integer *iy, doublereal *y, integer *relind)
{
    /* System generated locals */
    integer i__1, i__2;

    /* Local variables */
    static integer isub;
    static doublereal a;
    static integer i, k, ylast, col;


/* ***********************************************************************
 */

/*       ----------- */
/*       PARAMETERS. */
/*       ----------- */


/*       ---------------- */
/*       LOCAL VARIABLES. */
/*       ---------------- */


/* ***********************************************************************
 */

    /* Parameter adjustments */
    --relind;
    --y;
    --iy;
    --x;
    --xpnt;

    /* Function Body */
    i__1 = *q;
    for (k = 1; k <= i__1; ++k) {
	col = xpnt[k];
	ylast = iy[col + 1] - 1;
	a = -x[k];
/* DIR$   IVDEP */
	i__2 = *m;
	for (i = k; i <= i__2; ++i) {
	    isub = xpnt[i];
	    isub = ylast - relind[isub];
	    y[isub] += a * x[i];
/* L100: */
	}
/* L200: */
    }
    return 0;

} /* mmpyi_ */

/* *********************************************************************** */
/* *********************************************************************** */

/*   Version:        0.3 */
/*   Last modified:  December 27, 1994 */
/*   Authors:        Esmond G. Ng and Barry W. Peyton */

/*   Mathematical Sciences Section, Oak Ridge National Laboratory */

/* *********************************************************************** */
/* *********************************************************************** */
/* **************     MMPY  .... MATRIX-MATRIX MULTIPLY     ************** */
/* *********************************************************************** */
/* *********************************************************************** */

/*   PURPOSE - */
/*       THIS ROUTINE PERFORMS A MATRIX-MATRIX MULTIPLY, Y = Y + XA, */
/*       ASSUMING DATA STRUCTURES USED IN SOME OF OUR SPARSE CHOLESKY */
/*       CODES. */

/*   INPUT PARAMETERS - */
/*       M               -   NUMBER OF ROWS IN X AND IN Y. */
/*       N               -   NUMBER OF COLUMNS IN X AND NUMBER OF ROWS */
/*                           IN A. */
/*       Q               -   NUMBER OF COLUMNS IN A AND Y. */
/*       SPLIT(*)        -   BLOCK PARTITIONING OF X. */
/*       XPNT(*)         -   XPNT(J+1) POINTS ONE LOCATION BEYOND THE */
/*                           END OF THE J-TH COLUMN OF X.  XPNT IS ALSO */
/*                           USED TO ACCESS THE ROWS OF A. */
/*       X(*)            -   CONTAINS THE COLUMNS OF X AND THE ROWS OF A. */
/*       LDY             -   LENGTH OF FIRST COLUMN OF Y. */
/*       MMPYN           -   EXTERNAL ROUTINE: MATRIX-MATRIX MULTIPLY, */
/*                           WITH LEVEL N LOOP UNROLLING. */

/*   UPDATED PARAMETERS - */
/*       Y(*)            -   ON OUTPUT, Y = Y + AX. */

/* *********************************************************************** */

/* Subroutine */ int mmpy_(integer *m, integer *n, integer *q, integer *split,
	 integer *xpnt, doublereal *x, doublereal *y, integer *ldy, S_fp 
	mmpyn)
{
    static integer nn, fstcol, blk;


/* ***********************************************************************
 */

/*       ----------- */
/*       PARAMETERS. */
/*       ----------- */


/*       ---------------- */
/*       LOCAL VARIABLES. */
/*       ---------------- */


/* ***********************************************************************
 */

    /* Parameter adjustments */
    --y;
    --x;
    --xpnt;
    --split;

    /* Function Body */
    blk = 1;
    fstcol = 1;
L100:
    if (fstcol <= *n) {
	nn = split[blk];
	(*mmpyn)(m, &nn, q, &xpnt[fstcol], &x[1], &y[1], ldy);
	fstcol += nn;
	++blk;
	goto L100;
    }
    return 0;

} /* mmpy_ */

/* *********************************************************************** */
/* *********************************************************************** */

/*   Version:        0.3 */
/*   Last modified:  December 27, 1994 */
/*   Authors:        Esmond G. Ng and Barry W. Peyton */

/*   Mathematical Sciences Section, Oak Ridge National Laboratory */

/* *********************************************************************** */
/* *********************************************************************** */
/* *************     MMPY1  .... MATRIX-MATRIX MULTIPLY     ************** */
/* *********************************************************************** */
/* *********************************************************************** */

/*   PURPOSE - */
/*       THIS ROUTINE PERFORMS A MATRIX-MATRIX MULTIPLY, Y = Y + XA, */
/*       ASSUMING DATA STRUCTURES USED IN SOME OF OUR SPARSE CHOLESKY */
/*       CODES. */

/*       LOOP UNROLLING: LEVEL 1 */

/*   INPUT PARAMETERS - */
/*       M               -   NUMBER OF ROWS IN X AND IN Y. */
/*       N               -   NUMBER OF COLUMNS IN X AND NUMBER OF ROWS */
/*                           IN A. */
/*       Q               -   NUMBER OF COLUMNS IN A AND Y. */
/*       XPNT(*)         -   XPNT(J+1) POINTS ONE LOCATION BEYOND THE */
/*                           END OF THE J-TH COLUMN OF X.  XPNT IS ALSO */
/*                           USED TO ACCESS THE ROWS OF A. */
/*       X(*)            -   CONTAINS THE COLUMNS OF X AND THE ROWS OF A. */
/*       LDY             -   LENGTH OF FIRST COLUMN OF Y. */

/*   UPDATED PARAMETERS - */
/*       Y(*)            -   ON OUTPUT, Y = Y + AX. */

/* *********************************************************************** */

/* Subroutine */ int mmpy1_(integer *m, integer *n, integer *q, integer *xpnt,
	 doublereal *x, doublereal *y, integer *ldy)
{
    /* System generated locals */
    integer i__1, i__2, i__3;

    /* Local variables */
    static integer xcol, ycol, leny;
    static doublereal a1;
    static integer i1, mm, iy, iylast, iystop, iystrt;


/* ***********************************************************************
 */

/*       ----------- */
/*       PARAMETERS. */
/*       ----------- */


/*       ---------------- */
/*       LOCAL VARIABLES. */
/*       ---------------- */


/* ***********************************************************************
 */

    /* Parameter adjustments */
    --y;
    --x;
    --xpnt;

    /* Function Body */
    mm = *m;
    iylast = 0;
    leny = *ldy;
/*       ------------------------------------ */
/*       TO COMPUTE EACH COLUMN YCOL OF Y ... */
/*       ------------------------------------ */
    i__1 = *q;
    for (ycol = 1; ycol <= i__1; ++ycol) {
	iystrt = iylast + 1;
	iystop = iystrt + mm - 1;
	iylast += leny;
/*           -------------------------------------------------- */
/*           ... PERFORM THE APPROPRATE MATRIX VECTOR MULTIPLY: */
/*               X * A(*,YCOL). */
/*           -------------------------------------------------- */
	i__2 = *n;
	for (xcol = 1; xcol <= i__2; ++xcol) {
	    i1 = xpnt[xcol + 1] - mm;
	    a1 = -x[i1];
	    i__3 = iystop;
	    for (iy = iystrt; iy <= i__3; ++iy) {
		y[iy] += a1 * x[i1];
		++i1;
/* L100: */
	    }
/* L200: */
	}
	--mm;
	--leny;
/* L300: */
    }

    return 0;
} /* mmpy1_ */

/* *********************************************************************** */
/* *********************************************************************** */

/*   Version:        0.3 */
/*   Last modified:  December 27, 1994 */
/*   Authors:        Esmond G. Ng and Barry W. Peyton */

/*   Mathematical Sciences Section, Oak Ridge National Laboratory */

/* *********************************************************************** */
/* *********************************************************************** */
/* *************     MMPY2  .... MATRIX-MATRIX MULTIPLY     ************** */
/* *********************************************************************** */
/* *********************************************************************** */

/*   PURPOSE - */
/*       THIS ROUTINE PERFORMS A MATRIX-MATRIX MULTIPLY, Y = Y + XA, */
/*       ASSUMING DATA STRUCTURES USED IN SOME OF OUR SPARSE CHOLESKY */
/*       CODES. */

/*       LOOP UNROLLING: LEVEL 2 */

/*   INPUT PARAMETERS - */
/*       M               -   NUMBER OF ROWS IN X AND IN Y. */
/*       N               -   NUMBER OF COLUMNS IN X AND NUMBER OF ROWS */
/*                           IN A. */
/*       Q               -   NUMBER OF COLUMNS IN A AND Y. */
/*       XPNT(*)         -   XPNT(J+1) POINTS ONE LOCATION BEYOND THE */
/*                           END OF THE J-TH COLUMN OF X.  XPNT IS ALSO */
/*                           USED TO ACCESS THE ROWS OF A. */
/*       X(*)            -   CONTAINS THE COLUMNS OF X AND THE ROWS OF A. */
/*       LDY             -   LENGTH OF FIRST COLUMN OF Y. */

/*   UPDATED PARAMETERS - */
/*       Y(*)            -   ON OUTPUT, Y = Y + AX. */

/* *********************************************************************** */

/* Subroutine */ int mmpy2_(integer *m, integer *n, integer *q, integer *xpnt,
	 doublereal *x, doublereal *y, integer *ldy)
{
    /* System generated locals */
    integer i__1, i__2, i__3;

    /* Local variables */
    static integer xcol, ycol, leny;
    static doublereal a1, a2;
    static integer i1, i2, mm, iy, remain, iylast, iystop, iystrt;


/* ***********************************************************************
 */

/*       ----------- */
/*       PARAMETERS. */
/*       ----------- */


/*       ---------------- */
/*       LOCAL VARIABLES. */
/*       ---------------- */



/* ***********************************************************************
 */

/*       ----------------------------------------------------------- */
/*       INITIAL OFFSETS, COLUMN LENGTHS, AND INDEX RANGE VARIABLES. */
/*       ----------------------------------------------------------- */
    /* Parameter adjustments */
    --y;
    --x;
    --xpnt;

    /* Function Body */
    remain = *n % 2 + 1;
    mm = *m;
    iylast = 0;
    leny = *ldy;

/*       ------------------------------------ */
/*       TO COMPUTE EACH COLUMN YCOL OF Y ... */
/*       ------------------------------------ */

    i__1 = *q;
    for (ycol = 1; ycol <= i__1; ++ycol) {

	iystrt = iylast + 1;
	iystop = iystrt + mm - 1;
	iylast += leny;

/*           -------------------------------------------------- */
/*           ... PERFORM THE APPROPRATE MATRIX VECTOR MULTIPLY: */
/*               X * A(*,YCOL) WITH LEVEL 2 LOOP-UNROLLING. */
/*           -------------------------------------------------- */
	switch (remain) {
	    case 1:  goto L200;
	    case 2:  goto L100;
	}

L100:
	i1 = xpnt[2] - mm;
	a1 = -x[i1];
	i__2 = iystop;
	for (iy = iystrt; iy <= i__2; ++iy) {
	    y[iy] += a1 * x[i1];
	    ++i1;
/* L150: */
	}
	goto L200;

L200:
	i__2 = *n;
	for (xcol = remain; xcol <= i__2; xcol += 2) {
	    i1 = xpnt[xcol + 1] - mm;
	    i2 = xpnt[xcol + 2] - mm;
	    a1 = -x[i1];
	    a2 = -x[i2];
	    i__3 = iystop;
	    for (iy = iystrt; iy <= i__3; ++iy) {
		y[iy] = y[iy] + a1 * x[i1] + a2 * x[i2];
		++i1;
		++i2;
/* L300: */
	    }
/* L400: */
	}

	--mm;
	--leny;

/* L500: */
    }

    return 0;
} /* mmpy2_ */

/* *********************************************************************** */
/* *********************************************************************** */

/*   Version:        0.3 */
/*   Last modified:  December 27, 1994 */
/*   Authors:        Esmond G. Ng and Barry W. Peyton */

/*   Mathematical Sciences Section, Oak Ridge National Laboratory */

/* *********************************************************************** */
/* *********************************************************************** */
/* *************     MMPY4  .... MATRIX-MATRIX MULTIPLY     ************** */
/* *********************************************************************** */
/* *********************************************************************** */

/*   PURPOSE - */
/*       THIS ROUTINE PERFORMS A MATRIX-MATRIX MULTIPLY, Y = Y + XA, */
/*       ASSUMING DATA STRUCTURES USED IN SOME OF OUR SPARSE CHOLESKY */
/*       CODES. */

/*       LOOP UNROLLING: LEVEL 4 */

/*   INPUT PARAMETERS - */
/*       M               -   NUMBER OF ROWS IN X AND IN Y. */
/*       N               -   NUMBER OF COLUMNS IN X AND NUMBER OF ROWS */
/*                           IN A. */
/*       Q               -   NUMBER OF COLUMNS IN A AND Y. */
/*       XPNT(*)         -   XPNT(J+1) POINTS ONE LOCATION BEYOND THE */
/*                           END OF THE J-TH COLUMN OF X.  XPNT IS ALSO */
/*                           USED TO ACCESS THE ROWS OF A. */
/*       X(*)            -   CONTAINS THE COLUMNS OF X AND THE ROWS OF A. */
/*       LDY             -   LENGTH OF FIRST COLUMN OF Y. */

/*   UPDATED PARAMETERS - */
/*       Y(*)            -   ON OUTPUT, Y = Y + AX. */

/* *********************************************************************** */

/* Subroutine */ int mmpy4_(integer *m, integer *n, integer *q, integer *xpnt,
	 doublereal *x, doublereal *y, integer *ldy)
{
    /* System generated locals */
    integer i__1, i__2, i__3;

    /* Local variables */
    static integer xcol, ycol, leny;
    static doublereal a1, a2, a3, a4;
    static integer i1, i2, i3, i4, mm, iy, remain, iylast, iystop, iystrt;


/* ***********************************************************************
 */

/*       ----------- */
/*       PARAMETERS. */
/*       ----------- */


/*       ---------------- */
/*       LOCAL VARIABLES. */
/*       ---------------- */



/* ***********************************************************************
 */

/*       ----------------------------------------------------------- */
/*       INITIAL OFFSETS, COLUMN LENGTHS, AND INDEX RANGE VARIABLES. */
/*       ----------------------------------------------------------- */
    /* Parameter adjustments */
    --y;
    --x;
    --xpnt;

    /* Function Body */
    remain = *n % 4 + 1;
    mm = *m;
    iylast = 0;
    leny = *ldy;

/*       ------------------------------------ */
/*       TO COMPUTE EACH COLUMN YCOL OF Y ... */
/*       ------------------------------------ */

    i__1 = *q;
    for (ycol = 1; ycol <= i__1; ++ycol) {

	iystrt = iylast + 1;
	iystop = iystrt + mm - 1;
	iylast += leny;

/*           -------------------------------------------------- */
/*           ... PERFORM THE APPROPRATE MATRIX VECTOR MULTIPLY: */
/*               X * A(*,YCOL) WITH LEVEL 4 LOOP-UNROLLING. */
/*           -------------------------------------------------- */

	switch (remain) {
	    case 1:  goto L400;
	    case 2:  goto L100;
	    case 3:  goto L200;
	    case 4:  goto L300;
	}

L100:
	i1 = xpnt[2] - mm;
	a1 = -x[i1];
	i__2 = iystop;
	for (iy = iystrt; iy <= i__2; ++iy) {
	    y[iy] += a1 * x[i1];
	    ++i1;
/* L150: */
	}
	goto L400;

L200:
	i1 = xpnt[2] - mm;
	i2 = xpnt[3] - mm;
	a1 = -x[i1];
	a2 = -x[i2];
	i__2 = iystop;
	for (iy = iystrt; iy <= i__2; ++iy) {
	    y[iy] = y[iy] + a1 * x[i1] + a2 * x[i2];
	    ++i1;
	    ++i2;
/* L250: */
	}
	goto L400;

L300:
	i1 = xpnt[2] - mm;
	i2 = xpnt[3] - mm;
	i3 = xpnt[4] - mm;
	a1 = -x[i1];
	a2 = -x[i2];
	a3 = -x[i3];
	i__2 = iystop;
	for (iy = iystrt; iy <= i__2; ++iy) {
	    y[iy] = y[iy] + a1 * x[i1] + a2 * x[i2] + a3 * x[i3];
	    ++i1;
	    ++i2;
	    ++i3;
/* L350: */
	}
	goto L400;

L400:
	i__2 = *n;
	for (xcol = remain; xcol <= i__2; xcol += 4) {
	    i1 = xpnt[xcol + 1] - mm;
	    i2 = xpnt[xcol + 2] - mm;
	    i3 = xpnt[xcol + 3] - mm;
	    i4 = xpnt[xcol + 4] - mm;
	    a1 = -x[i1];
	    a2 = -x[i2];
	    a3 = -x[i3];
	    a4 = -x[i4];
	    i__3 = iystop;
	    for (iy = iystrt; iy <= i__3; ++iy) {
		y[iy] = y[iy] + a1 * x[i1] + a2 * x[i2] + a3 * x[i3] + a4 * x[
			i4];
		++i1;
		++i2;
		++i3;
		++i4;
/* L500: */
	    }
/* L600: */
	}

	--mm;
	--leny;

/* L700: */
    }

    return 0;
} /* mmpy4_ */

/* *********************************************************************** */
/* *********************************************************************** */

/*   Version:        0.3 */
/*   Last modified:  December 27, 1994 */
/*   Authors:        Esmond G. Ng and Barry W. Peyton */

/*   Mathematical Sciences Section, Oak Ridge National Laboratory */

/* *********************************************************************** */
/* *********************************************************************** */
/* *************     MMPY8  .... MATRIX-MATRIX MULTIPLY     ************** */
/* *********************************************************************** */
/* *********************************************************************** */

/*   PURPOSE - */
/*       THIS ROUTINE PERFORMS A MATRIX-MATRIX MULTIPLY, Y = Y + XA, */
/*       ASSUMING DATA STRUCTURES USED IN SOME OF OUR SPARSE CHOLESKY */
/*       CODES. */

/*       LOOP UNROLLING: LEVEL 8 */

/*   INPUT PARAMETERS - */
/*       M               -   NUMBER OF ROWS IN X AND IN Y. */
/*       N               -   NUMBER OF COLUMNS IN X AND NUMBER OF ROWS */
/*                           IN A. */
/*       Q               -   NUMBER OF COLUMNS IN A AND Y. */
/*       XPNT(*)         -   XPNT(J+1) POINTS ONE LOCATION BEYOND THE */
/*                           END OF THE J-TH COLUMN OF X.  XPNT IS ALSO */
/*                           USED TO ACCESS THE ROWS OF A. */
/*       X(*)            -   CONTAINS THE COLUMNS OF X AND THE ROWS OF A. */
/*       LDY             -   LENGTH OF FIRST COLUMN OF Y. */

/*   UPDATED PARAMETERS - */
/*       Y(*)            -   ON OUTPUT, Y = Y + AX. */

/* *********************************************************************** */

/* Subroutine */ int mmpy8_(integer *m, integer *n, integer *q, integer *xpnt,
	 doublereal *x, doublereal *y, integer *ldy)
{
    /* System generated locals */
    integer i__1, i__2, i__3;

    /* Local variables */
    static integer xcol, ycol, leny;
    static doublereal a1, a2, a3, a4, a5, a6, a7, a8;
    static integer i1, i2, i3, i4, i5, i6, i7, i8, mm, iy, remain, iylast, 
	    iystop, iystrt;


/* ***********************************************************************
 */

/*       ----------- */
/*       PARAMETERS. */
/*       ----------- */


/*       ---------------- */
/*       LOCAL VARIABLES. */
/*       ---------------- */



/* ***********************************************************************
 */

/*       ----------------------------------------------------------- */
/*       INITIAL OFFSETS, COLUMN LENGTHS, AND INDEX RANGE VARIABLES. */
/*       ----------------------------------------------------------- */
    /* Parameter adjustments */
    --y;
    --x;
    --xpnt;

    /* Function Body */
    remain = *n % 8 + 1;
    mm = *m;
    iylast = 0;
    leny = *ldy;

/*       ------------------------------------ */
/*       TO COMPUTE EACH COLUMN YCOL OF Y ... */
/*       ------------------------------------ */

    i__1 = *q;
    for (ycol = 1; ycol <= i__1; ++ycol) {

	iystrt = iylast + 1;
	iystop = iystrt + mm - 1;
	iylast += leny;

/*           -------------------------------------------------- */
/*           ... PERFORM THE APPROPRATE MATRIX VECTOR MULTIPLY: */
/*               X * A(*,YCOL) WITH LEVEL 8 LOOP-UNROLLING. */
/*           -------------------------------------------------- */

	switch (remain) {
	    case 1:  goto L800;
	    case 2:  goto L100;
	    case 3:  goto L200;
	    case 4:  goto L300;
	    case 5:  goto L400;
	    case 6:  goto L500;
	    case 7:  goto L600;
	    case 8:  goto L700;
	}

L100:
	i1 = xpnt[2] - mm;
	a1 = -x[i1];
	i__2 = iystop;
	for (iy = iystrt; iy <= i__2; ++iy) {
	    y[iy] += a1 * x[i1];
	    ++i1;
/* L150: */
	}
	goto L800;

L200:
	i1 = xpnt[2] - mm;
	i2 = xpnt[3] - mm;
	a1 = -x[i1];
	a2 = -x[i2];
	i__2 = iystop;
	for (iy = iystrt; iy <= i__2; ++iy) {
	    y[iy] = y[iy] + a1 * x[i1] + a2 * x[i2];
	    ++i1;
	    ++i2;
/* L250: */
	}
	goto L800;

L300:
	i1 = xpnt[2] - mm;
	i2 = xpnt[3] - mm;
	i3 = xpnt[4] - mm;
	a1 = -x[i1];
	a2 = -x[i2];
	a3 = -x[i3];
	i__2 = iystop;
	for (iy = iystrt; iy <= i__2; ++iy) {
	    y[iy] = y[iy] + a1 * x[i1] + a2 * x[i2] + a3 * x[i3];
	    ++i1;
	    ++i2;
	    ++i3;
/* L350: */
	}
	goto L800;

L400:
	i1 = xpnt[2] - mm;
	i2 = xpnt[3] - mm;
	i3 = xpnt[4] - mm;
	i4 = xpnt[5] - mm;
	a1 = -x[i1];
	a2 = -x[i2];
	a3 = -x[i3];
	a4 = -x[i4];
	i__2 = iystop;
	for (iy = iystrt; iy <= i__2; ++iy) {
	    y[iy] = y[iy] + a1 * x[i1] + a2 * x[i2] + a3 * x[i3] + a4 * x[i4];
	    ++i1;
	    ++i2;
	    ++i3;
	    ++i4;
/* L450: */
	}
	goto L800;

L500:
	i1 = xpnt[2] - mm;
	i2 = xpnt[3] - mm;
	i3 = xpnt[4] - mm;
	i4 = xpnt[5] - mm;
	i5 = xpnt[6] - mm;
	a1 = -x[i1];
	a2 = -x[i2];
	a3 = -x[i3];
	a4 = -x[i4];
	a5 = -x[i5];
	i__2 = iystop;
	for (iy = iystrt; iy <= i__2; ++iy) {
	    y[iy] = y[iy] + a1 * x[i1] + a2 * x[i2] + a3 * x[i3] + a4 * x[i4] 
		    + a5 * x[i5];
	    ++i1;
	    ++i2;
	    ++i3;
	    ++i4;
	    ++i5;
/* L550: */
	}
	goto L800;

L600:
	i1 = xpnt[2] - mm;
	i2 = xpnt[3] - mm;
	i3 = xpnt[4] - mm;
	i4 = xpnt[5] - mm;
	i5 = xpnt[6] - mm;
	i6 = xpnt[7] - mm;
	a1 = -x[i1];
	a2 = -x[i2];
	a3 = -x[i3];
	a4 = -x[i4];
	a5 = -x[i5];
	a6 = -x[i6];
	i__2 = iystop;
	for (iy = iystrt; iy <= i__2; ++iy) {
	    y[iy] = y[iy] + a1 * x[i1] + a2 * x[i2] + a3 * x[i3] + a4 * x[i4] 
		    + a5 * x[i5] + a6 * x[i6];
	    ++i1;
	    ++i2;
	    ++i3;
	    ++i4;
	    ++i5;
	    ++i6;
/* L650: */
	}
	goto L800;

L700:
	i1 = xpnt[2] - mm;
	i2 = xpnt[3] - mm;
	i3 = xpnt[4] - mm;
	i4 = xpnt[5] - mm;
	i5 = xpnt[6] - mm;
	i6 = xpnt[7] - mm;
	i7 = xpnt[8] - mm;
	a1 = -x[i1];
	a2 = -x[i2];
	a3 = -x[i3];
	a4 = -x[i4];
	a5 = -x[i5];
	a6 = -x[i6];
	a7 = -x[i7];
	i__2 = iystop;
	for (iy = iystrt; iy <= i__2; ++iy) {
	    y[iy] = y[iy] + a1 * x[i1] + a2 * x[i2] + a3 * x[i3] + a4 * x[i4] 
		    + a5 * x[i5] + a6 * x[i6] + a7 * x[i7];
	    ++i1;
	    ++i2;
	    ++i3;
	    ++i4;
	    ++i5;
	    ++i6;
	    ++i7;
/* L750: */
	}
	goto L800;

L800:
	i__2 = *n;
	for (xcol = remain; xcol <= i__2; xcol += 8) {
	    i1 = xpnt[xcol + 1] - mm;
	    i2 = xpnt[xcol + 2] - mm;
	    i3 = xpnt[xcol + 3] - mm;
	    i4 = xpnt[xcol + 4] - mm;
	    i5 = xpnt[xcol + 5] - mm;
	    i6 = xpnt[xcol + 6] - mm;
	    i7 = xpnt[xcol + 7] - mm;
	    i8 = xpnt[xcol + 8] - mm;
	    a1 = -x[i1];
	    a2 = -x[i2];
	    a3 = -x[i3];
	    a4 = -x[i4];
	    a5 = -x[i5];
	    a6 = -x[i6];
	    a7 = -x[i7];
	    a8 = -x[i8];
	    i__3 = iystop;
	    for (iy = iystrt; iy <= i__3; ++iy) {
		y[iy] = y[iy] + a1 * x[i1] + a2 * x[i2] + a3 * x[i3] + a4 * x[
			i4] + a5 * x[i5] + a6 * x[i6] + a7 * x[i7] + a8 * x[
			i8];
		++i1;
		++i2;
		++i3;
		++i4;
		++i5;
		++i6;
		++i7;
		++i8;
/* L900: */
	    }
/* L1000: */
	}

	--mm;
	--leny;

/* L1100: */
    }

    return 0;
} /* mmpy8_ */

/* *********************************************************************** */
/* *********************************************************************** */

/*   Version:        0.3 */
/*   Last modified:  December 27, 1994 */
/*   Authors:        Esmond G. Ng and Barry W. Peyton */

/*   Mathematical Sciences Section, Oak Ridge National Laboratory */

/* *********************************************************************** */
/* *********************************************************************** */
/* ******         IGATHR .... INTEGER GATHER OPERATION      ************** */
/* *********************************************************************** */
/* *********************************************************************** */

/*     PURPOSE - THIS ROUTINE PERFORMS A STANDARD INTEGER GATHER */
/*               OPERATION. */

/*     INPUT PARAMETERS - */
/*        KLEN   - LENGTH OF THE LIST OF GLOBAL INDICES. */
/*        LINDX  - LIST OF GLOBAL INDICES. */
/*        INDMAP - INDEXED BY GLOBAL INDICES, IT CONTAINS THE */
/*                 REQUIRED RELATIVE INDICES. */

/*     OUTPUT PARAMETERS - */
/*        RELIND - LIST RELATIVE INDICES. */

/* *********************************************************************** */

/* Subroutine */ int igathr_(integer *klen, integer *lindx, integer *indmap, 
	integer *relind)
{
    /* System generated locals */
    integer i__1;

    /* Local variables */
    static integer i;


/* ***********************************************************************
 */

/*     ----------- */
/*     PARAMETERS. */
/*     ----------- */

/*     ---------------- */
/*     LOCAL VARIABLES. */
/*     ---------------- */

/* ***********************************************************************
 */

/* DIR$ IVDEP */
    /* Parameter adjustments */
    --relind;
    --indmap;
    --lindx;

    /* Function Body */
    i__1 = *klen;
    for (i = 1; i <= i__1; ++i) {
	relind[i] = indmap[lindx[i]];
/* L100: */
    }
    return 0;
} /* igathr_ */

/* *********************************************************************** */
/* *********************************************************************** */

/*   Version:        0.3 */
/*   Last modified:  December 27, 1994 */
/*   Authors:        Esmond G. Ng and Barry W. Peyton */

/*   Mathematical Sciences Section, Oak Ridge National Laboratory */

/* *********************************************************************** */
/* *********************************************************************** */
/* ************     ASSMB .... INDEXED ASSEMBLY OPERATION     ************ */
/* *********************************************************************** */
/* *********************************************************************** */

/*   PURPOSE: */
/*       THIS ROUTINE PERFORMS AN INDEXED ASSEMBLY (I.E., SCATTER-ADD) */
/*       OPERATION, ASSUMING DATA STRUCTURES USED IN SOME OF OUR SPARSE */
/*       CHOLESKY CODES. */

/*   INPUT PARAMETERS: */
/*       M               -   NUMBER OF ROWS IN Y. */
/*       Q               -   NUMBER OF COLUMNS IN Y. */
/*       Y               -   BLOCK UPDATE TO BE INCORPORATED INTO FACTOR */
/*                           STORAGE. */
/*       RELIND          -   RELATIVE INDICES FOR MAPPING THE UPDATES */
/*                           ONTO THE TARGET COLUMNS. */
/*       XLNZ            -   POINTERS TO THE START OF EACH COLUMN IN THE */
/*                           TARGET MATRIX. */

/*   OUTPUT PARAMETERS: */
/*       LNZ             -   CONTAINS COLUMNS MODIFIED BY THE UPDATE */
/*                           MATRIX. */

/* *********************************************************************** */

/* Subroutine */ int assmb_(integer *m, integer *q, doublereal *y, integer *
	relind, integer *xlnz, doublereal *lnz, integer *lda)
{
    /* System generated locals */
    integer i__1, i__2;

    /* Local variables */
    static integer icol, ycol, lbot1, yoff1, ir, il1, iy1;


/* ***********************************************************************
 */

/*       ----------- */
/*       PARAMETERS. */
/*       ----------- */


/*       ---------------- */
/*       LOCAL VARIABLES. */
/*       ---------------- */


/* ***********************************************************************
 */


    /* Parameter adjustments */
    --lnz;
    --xlnz;
    --relind;
    --y;

    /* Function Body */
    yoff1 = 0;
    i__1 = *q;
    for (icol = 1; icol <= i__1; ++icol) {
	ycol = *lda - relind[icol];
	lbot1 = xlnz[ycol + 1] - 1;
/* DIR$ IVDEP */
	i__2 = *m;
	for (ir = icol; ir <= i__2; ++ir) {
	    il1 = lbot1 - relind[ir];
	    iy1 = yoff1 + ir;
	    lnz[il1] += y[iy1];
	    y[iy1] = 0.;
/* L100: */
	}
	yoff1 = iy1 - icol;
/* L200: */
    }

    return 0;
} /* assmb_ */

/* *********************************************************************** */
/* *********************************************************************** */

/*   Version:        0.3 */
/*   Last modified:  December 27, 1994 */
/*   Authors:        Esmond G. Ng and Barry W. Peyton */

/*   Mathematical Sciences Section, Oak Ridge National Laboratory */

/* *********************************************************************** */
/* *********************************************************************** */
/* ******     CHLSUP .... DENSE CHOLESKY WITHIN SUPERNODE   ************** */
/* *********************************************************************** */
/* *********************************************************************** */

/*     PURPOSE - THIS ROUTINE PERFORMS CHOLESKY */
/*               FACTORIZATION ON THE COLUMNS OF A SUPERNODE */
/*               THAT HAVE RECEIVED ALL UPDATES FROM COLUMNS */
/*               EXTERNAL TO THE SUPERNODE. */

/*     INPUT PARAMETERS - */
/*        M      - NUMBER OF ROWS (LENGTH OF THE FIRST COLUMN). */
/*        N      - NUMBER OF COLUMNS IN THE SUPERNODE. */
/*        XPNT   - XPNT(J+1) POINTS ONE LOCATION BEYOND THE END */
/*                 OF THE J-TH COLUMN OF THE SUPERNODE. */
/*        X(*)   - CONTAINS THE COLUMNS OF OF THE SUPERNODE TO */
/*                 BE FACTORED. */
/*        SMXPY  - EXTERNAL ROUTINE: MATRIX-VECTOR MULTIPLY. */

/*     OUTPUT PARAMETERS - */
/*        X(*)   - ON OUTPUT, CONTAINS THE FACTORED COLUMNS OF */
/*                 THE SUPERNODE. */
/*        IFLAG  - UNCHANGED IF THERE IS NO ERROR. */
/*                 =1 IF NONPOSITIVE DIAGONAL ENTRY IS ENCOUNTERED. */

/* *********************************************************************** */

/* Subroutine */ int chlsup_(integer *m, integer *n, integer *split, integer *
	xpnt, doublereal *x, integer *iflag, S_fp mmpyn, U_fp smxpy)
{
    static integer jblk, jpnt, q;
    extern /* Subroutine */ int pchol_(integer *, integer *, integer *, 
	    doublereal *, integer *, U_fp);
    static integer mm, nn, fstcol, nxtcol;


/* ***********************************************************************
 */

/*     ----------- */
/*     PARAMETERS. */
/*     ----------- */





/*     ---------------- */
/*     LOCAL VARIABLES. */
/*     ---------------- */


/* ***********************************************************************
 */

    /* Parameter adjustments */
    --x;
    --xpnt;
    --split;

    /* Function Body */
    jblk = 0;
    fstcol = 1;
    mm = *m;
    jpnt = xpnt[fstcol];

/*       ---------------------------------------- */
/*       FOR EACH BLOCK JBLK IN THE SUPERNODE ... */
/*       ---------------------------------------- */
L100:
    if (fstcol <= *n) {
	++jblk;
	nn = split[jblk];
/*           ------------------------------------------ */
/*           ... PERFORM PARTIAL CHOLESKY FACTORIZATION */
/*               ON THE BLOCK. */
/*           ------------------------------------------ */
	pchol_(&mm, &nn, &xpnt[fstcol], &x[1], iflag, (U_fp)smxpy);
	if (*iflag == 1) {
	    return 0;
	}
/*           ---------------------------------------------- */
/*           ... APPLY THE COLUMNS IN JBLK TO ANY COLUMNS */
/*               OF THE SUPERNODE REMAINING TO BE COMPUTED. */
/*           ---------------------------------------------- */
	nxtcol = fstcol + nn;
	q = *n - nxtcol + 1;
	mm -= nn;
	jpnt = xpnt[nxtcol];
	if (q > 0) {
	    (*mmpyn)(&mm, &nn, &q, &xpnt[fstcol], &x[1], &x[jpnt], &mm);
	}
	fstcol = nxtcol;
	goto L100;
    }

    return 0;
} /* chlsup_ */

/* *********************************************************************** */
/* *********************************************************************** */

/*   Version:        0.3 */
/*   Last modified:  December 27, 1994 */
/*   Authors:        Esmond G. Ng and Barry W. Peyton */

/*   Mathematical Sciences Section, Oak Ridge National Laboratory */

/* *********************************************************************** */
/* *********************************************************************** */
/* ******     PCHOL .... DENSE PARTIAL CHOLESKY             ************** */
/* *********************************************************************** */
/* *********************************************************************** */

/*     PURPOSE - THIS ROUTINE PERFORMS CHOLESKY */
/*               FACTORIZATION ON THE COLUMNS OF A SUPERNODE */
/*               THAT HAVE RECEIVED ALL UPDATES FROM COLUMNS */
/*               EXTERNAL TO THE SUPERNODE. */

/*     INPUT PARAMETERS - */
/*        M      - NUMBER OF ROWS (LENGTH OF THE FIRST COLUMN). */
/*        N      - NUMBER OF COLUMNS IN THE SUPERNODE. */
/*        XPNT   - XPNT(J+1) POINTS ONE LOCATION BEYOND THE END */
/*                 OF THE J-TH COLUMN OF THE SUPERNODE. */
/*        X(*)   - CONTAINS THE COLUMNS OF OF THE SUPERNODE TO */
/*                 BE FACTORED. */
/*        SMXPY  - EXTERNAL ROUTINE: MATRIX-VECTOR MULTIPLY. */

/*     OUTPUT PARAMETERS - */
/*        X(*)   - ON OUTPUT, CONTAINS THE FACTORED COLUMNS OF */
/*                 THE SUPERNODE. */
/*        IFLAG  - UNCHANGED IF THERE IS NO ERROR. */
/*                 =1 IF NONPOSITIVE DIAGONAL ENTRY IS ENCOUNTERED. */

/* *********************************************************************** */

/* Subroutine */ int pchol_(integer *m, integer *n, integer *xpnt, doublereal 
	*x, integer *iflag, S_fp smxpy)
{
    /* System generated locals */
    integer i__1, i__2;
    doublereal d__1;

    /* Builtin functions */
    double sqrt(doublereal);

    /* Local variables */
    static doublereal diag;
    static integer jcol, jpnt;
    extern /* Subroutine */ int dscal_(integer *, doublereal *, doublereal *);
    static integer mm;
    static doublereal mxdiag;


/* ***********************************************************************
 */

/*     ----------- */
/*     PARAMETERS. */
/*     ----------- */





/*     ---------------- */
/*     LOCAL VARIABLES. */
/*     ---------------- */



/* ***********************************************************************
 */

/*       ------------------------------------------ */
/*       FOR EVERY COLUMN JCOL IN THE SUPERNODE ... */
/*       ------------------------------------------ */
    /* Parameter adjustments */
    --x;
    --xpnt;

    /* Function Body */
    mm = *m;
    jpnt = xpnt[1];
    mxdiag = 1.;
    i__1 = *n;
    for (jcol = 1; jcol <= i__1; ++jcol) {

/*           ---------------------------------- */
/*           UPDATE JCOL WITH PREVIOUS COLUMNS. */
/*           ---------------------------------- */
	if (jcol > 1) {
	    i__2 = jcol - 1;
	    (*smxpy)(&mm, &i__2, &x[jpnt], &xpnt[1], &x[1]);
	}

/*           --------------------------- */
/*           COMPUTE THE DIAGONAL ENTRY. */
/*           --------------------------- */
	diag = x[jpnt];
	mxdiag = max(mxdiag,diag);
/* Computing MIN */
	d__1 = mxdiag * 1e-15;
	if (diag <= min(d__1,1e-10)) {
	    diag = 1e128;
	}
	diag = sqrt(diag);
	x[jpnt] = diag;
	diag = 1. / diag;

/*           ---------------------------------------------------- */
/*           SCALE COLUMN JCOL WITH RECIPROCAL OF DIAGONAL ENTRY. */
/*           ---------------------------------------------------- */
	--mm;
	++jpnt;
	dscal_(&mm, &diag, &x[jpnt]);
	jpnt += mm;

/* L100: */
    }

    return 0;
} /* pchol_ */

/* *********************************************************************** */
/* *********************************************************************** */

/*   Version:        0.3 */
/*   Last modified:  December 27, 1994 */
/*   Authors:        Esmond G. Ng and Barry W. Peyton */

/*   Mathematical Sciences Section, Oak Ridge National Laboratory */

/* *********************************************************************** */
/* *********************************************************************** */
/* ******     DSCAL .... SCALE A VECTOR                     ************** */
/* *********************************************************************** */
/* *********************************************************************** */

/*     PURPOSE - THIS ROUTINE COMPUTES A <-- AX, WHERE A IS A */
/*               SCALAR AND X IS A VECTOR. */

/*     INPUT PARAMETERS - */
/*        N - LENGTH OF THE VECTOR X. */
/*        A - SCALAR MULIPLIER. */
/*        X - VECTOR TO BE SCALED. */

/*     OUTPUT PARAMETERS - */
/*        X - REPLACED BY THE SCALED VECTOR, AX. */

/* *********************************************************************** */

/* Subroutine */ int dscal_(integer *n, doublereal *a, doublereal *x)
{
    /* System generated locals */
    integer i__1;

    /* Local variables */
    static integer i;


/* ***********************************************************************
 */

/*     ----------- */
/*     PARAMETERS. */
/*     ----------- */

/*     ---------------- */
/*     LOCAL VARIABLES. */
/*     ---------------- */

/* ***********************************************************************
 */

    /* Parameter adjustments */
    --x;

    /* Function Body */
    i__1 = *n;
    for (i = 1; i <= i__1; ++i) {
	x[i] = *a * x[i];
/* L100: */
    }
    return 0;
} /* dscal_ */

/* *********************************************************************** */
/* *********************************************************************** */

/*   Version:        0.3 */
/*   Last modified:  December 27, 1994 */
/*   Authors:        Esmond G. Ng and Barry W. Peyton */

/*   Mathematical Sciences Section, Oak Ridge National Laboratory */

/* *********************************************************************** */
/* *********************************************************************** */
/* ******     SMXPY1 .... MATRIX-VECTOR MULTIPLY            ************** */
/* *********************************************************************** */
/* *********************************************************************** */

/*     PURPOSE - THIS ROUTINE PERFORMS A MATRIX-VECTOR MULTIPLY, */
/*               Y = Y + AX, ASSUMING DATA STRUCTURES USED IN */
/*               RECENTLY DEVELOPED SPARSE CHOLESKY CODES.  THE */
/*               '1' SIGNIFIES NO LOOP UNROLLING, I.E., */
/*               LOOP-UNROLLING TO LEVEL 1. */

/*     INPUT PARAMETERS - */
/*        M      - NUMBER OF ROWS. */
/*        N      - NUMBER OF COLUMNS. */
/*        Y      - M-VECTOR TO WHICH AX WILL BE ADDED. */
/*        APNT   - INDEX VECTOR FOR A.  XA(I) POINTS TO THE */
/*                 FIRST NONZERO IN COLUMN I OF A. */
/*        Y      - ON OUTPUT, CONTAINS Y = Y + AX. */

/* *********************************************************************** */

/* Subroutine */ int smxpy1_(integer *m, integer *n, doublereal *y, integer *
	apnt, doublereal *a)
{
    /* System generated locals */
    integer i__1, i__2;

    /* Local variables */
    static integer i, j;
    static doublereal amult;
    static integer ii;


/* ***********************************************************************
 */

/*     ----------- */
/*     PARAMETERS. */
/*     ----------- */




/*     ---------------- */
/*     LOCAL VARIABLES. */
/*     ---------------- */



/* ***********************************************************************
 */

    /* Parameter adjustments */
    --a;
    --apnt;
    --y;

    /* Function Body */
    i__1 = *n;
    for (j = 1; j <= i__1; ++j) {
	ii = apnt[j + 1] - *m;
	amult = -a[ii];
	i__2 = *m;
	for (i = 1; i <= i__2; ++i) {
	    y[i] += amult * a[ii];
	    ++ii;
/* L100: */
	}
/* L200: */
    }
    return 0;
} /* smxpy1_ */

/* *********************************************************************** */
/* *********************************************************************** */

/*   Version:        0.3 */
/*   Last modified:  December 27, 1994 */
/*   Authors:        Esmond G. Ng and Barry W. Peyton */

/*   Mathematical Sciences Section, Oak Ridge National Laboratory */

/* *********************************************************************** */
/* *********************************************************************** */
/* ******     SMXPY2 .... MATRIX-VECTOR MULTIPLY            ************** */
/* *********************************************************************** */
/* *********************************************************************** */

/*     PURPOSE - THIS ROUTINE PERFORMS A MATRIX-VECTOR MULTIPLY, */
/*               Y = Y + AX, ASSUMING DATA STRUCTURES USED IN */
/*               RECENTLY DEVELOPED SPARSE CHOLESKY CODES.  THE */
/*               '2' SIGNIFIES LEVEL 2 LOOP UNROLLING. */

/*     INPUT PARAMETERS - */
/*        M      - NUMBER OF ROWS. */
/*        N      - NUMBER OF COLUMNS. */
/*        Y      - M-VECTOR TO WHICH AX WILL BE ADDED. */
/*        APNT   - INDEX VECTOR FOR A.  XA(I) POINTS TO THE */
/*                 FIRST NONZERO IN COLUMN I OF A. */
/*        Y      - ON OUTPUT, CONTAINS Y = Y + AX. */

/* *********************************************************************** */

/* Subroutine */ int smxpy2_(integer *m, integer *n, doublereal *y, integer *
	apnt, doublereal *a)
{
    /* System generated locals */
    integer i__1, i__2;

    /* Local variables */
    static integer i, j;
    static doublereal a1, a2;
    static integer i1, i2, remain;


/* ***********************************************************************
 */

/*     ----------- */
/*     PARAMETERS. */
/*     ----------- */





/*     ---------------- */
/*     LOCAL VARIABLES. */
/*     ---------------- */



/* ***********************************************************************
 */

    /* Parameter adjustments */
    --a;
    --apnt;
    --y;

    /* Function Body */
    remain = *n % 2;

    switch (remain + 1) {
	case 1:  goto L2000;
	case 2:  goto L100;
    }

L100:
    i1 = apnt[2] - *m;
    a1 = -a[i1];
    i__1 = *m;
    for (i = 1; i <= i__1; ++i) {
	y[i] += a1 * a[i1];
	++i1;
/* L150: */
    }
    goto L2000;

L2000:
    i__1 = *n;
    for (j = remain + 1; j <= i__1; j += 2) {
	i1 = apnt[j + 1] - *m;
	i2 = apnt[j + 2] - *m;
	a1 = -a[i1];
	a2 = -a[i2];
	i__2 = *m;
	for (i = 1; i <= i__2; ++i) {
	    y[i] = y[i] + a1 * a[i1] + a2 * a[i2];
	    ++i1;
	    ++i2;
/* L3000: */
	}
/* L4000: */
    }

    return 0;
} /* smxpy2_ */

/* *********************************************************************** */
/* *********************************************************************** */

/*   Version:        0.3 */
/*   Last modified:  December 27, 1994 */
/*   Authors:        Esmond G. Ng and Barry W. Peyton */

/*   Mathematical Sciences Section, Oak Ridge National Laboratory */

/* *********************************************************************** */
/* *********************************************************************** */
/* ******     SMXPY4 .... MATRIX-VECTOR MULTIPLY            ************** */
/* *********************************************************************** */
/* *********************************************************************** */

/*     PURPOSE - THIS ROUTINE PERFORMS A MATRIX-VECTOR MULTIPLY, */
/*               Y = Y + AX, ASSUMING DATA STRUCTURES USED IN */
/*               RECENTLY DEVELOPED SPARSE CHOLESKY CODES.  THE */
/*               '4' SIGNIFIES LEVEL 4 LOOP UNROLLING. */

/*     INPUT PARAMETERS - */
/*        M      - NUMBER OF ROWS. */
/*        N      - NUMBER OF COLUMNS. */
/*        Y      - M-VECTOR TO WHICH AX WILL BE ADDED. */
/*        APNT   - INDEX VECTOR FOR A.  XA(I) POINTS TO THE */
/*                 FIRST NONZERO IN COLUMN I OF A. */
/*        Y      - ON OUTPUT, CONTAINS Y = Y + AX. */

/* *********************************************************************** */

/* Subroutine */ int smxpy4_(integer *m, integer *n, doublereal *y, integer *
	apnt, doublereal *a)
{
    /* System generated locals */
    integer i__1, i__2;

    /* Local variables */
    static integer i, j;
    static doublereal a1, a2, a3, a4;
    static integer i1, i2, i3, i4, remain;


/* ***********************************************************************
 */

/*     ----------- */
/*     PARAMETERS. */
/*     ----------- */





/*     ---------------- */
/*     LOCAL VARIABLES. */
/*     ---------------- */



/* ***********************************************************************
 */

    /* Parameter adjustments */
    --a;
    --apnt;
    --y;

    /* Function Body */
    remain = *n % 4;

    switch (remain + 1) {
	case 1:  goto L2000;
	case 2:  goto L100;
	case 3:  goto L200;
	case 4:  goto L300;
    }

L100:
    i1 = apnt[2] - *m;
    a1 = -a[i1];
    i__1 = *m;
    for (i = 1; i <= i__1; ++i) {
	y[i] += a1 * a[i1];
	++i1;
/* L150: */
    }
    goto L2000;

L200:
    i1 = apnt[2] - *m;
    i2 = apnt[3] - *m;
    a1 = -a[i1];
    a2 = -a[i2];
    i__1 = *m;
    for (i = 1; i <= i__1; ++i) {
	y[i] = y[i] + a1 * a[i1] + a2 * a[i2];
	++i1;
	++i2;
/* L250: */
    }
    goto L2000;

L300:
    i1 = apnt[2] - *m;
    i2 = apnt[3] - *m;
    i3 = apnt[4] - *m;
    a1 = -a[i1];
    a2 = -a[i2];
    a3 = -a[i3];
    i__1 = *m;
    for (i = 1; i <= i__1; ++i) {
	y[i] = y[i] + a1 * a[i1] + a2 * a[i2] + a3 * a[i3];
	++i1;
	++i2;
	++i3;
/* L350: */
    }
    goto L2000;

L2000:
    i__1 = *n;
    for (j = remain + 1; j <= i__1; j += 4) {
	i1 = apnt[j + 1] - *m;
	i2 = apnt[j + 2] - *m;
	i3 = apnt[j + 3] - *m;
	i4 = apnt[j + 4] - *m;
	a1 = -a[i1];
	a2 = -a[i2];
	a3 = -a[i3];
	a4 = -a[i4];
	i__2 = *m;
	for (i = 1; i <= i__2; ++i) {
	    y[i] = y[i] + a1 * a[i1] + a2 * a[i2] + a3 * a[i3] + a4 * a[i4];
	    ++i1;
	    ++i2;
	    ++i3;
	    ++i4;
/* L3000: */
	}
/* L4000: */
    }

    return 0;
} /* smxpy4_ */

/* *********************************************************************** */
/* *********************************************************************** */

/*   Version:        0.3 */
/*   Last modified:  December 27, 1994 */
/*   Authors:        Esmond G. Ng and Barry W. Peyton */

/*   Mathematical Sciences Section, Oak Ridge National Laboratory */

/* *********************************************************************** */
/* *********************************************************************** */
/* ******     SMXPY8 .... MATRIX-VECTOR MULTIPLY            ************** */
/* *********************************************************************** */
/* *********************************************************************** */

/*     PURPOSE - THIS ROUTINE PERFORMS A MATRIX-VECTOR MULTIPLY, */
/*               Y = Y + AX, ASSUMING DATA STRUCTURES USED IN */
/*               RECENTLY DEVELOPED SPARSE CHOLESKY CODES.  THE */
/*               '8' SIGNIFIES LEVEL 8 LOOP UNROLLING. */

/*     INPUT PARAMETERS - */
/*        M      - NUMBER OF ROWS. */
/*        N      - NUMBER OF COLUMNS. */
/*        Y      - M-VECTOR TO WHICH AX WILL BE ADDED. */
/*        APNT   - INDEX VECTOR FOR A.  APNT(I) POINTS TO THE */
/*                 FIRST NONZERO IN COLUMN I OF A. */
/*        Y      - ON OUTPUT, CONTAINS Y = Y + AX. */

/* *********************************************************************** */

/* Subroutine */ int smxpy8_(integer *m, integer *n, doublereal *y, integer *
	apnt, doublereal *a)
{
    /* System generated locals */
    integer i__1, i__2;

    /* Local variables */
    static integer i, j;
    static doublereal a1, a2, a3, a4, a5, a6, a7, a8;
    static integer i1, i2, i3, i4, i5, i6, i7, i8, remain;


/* ***********************************************************************
 */

/*     ----------- */
/*     PARAMETERS. */
/*     ----------- */





/*     ---------------- */
/*     LOCAL VARIABLES. */
/*     ---------------- */



/* ***********************************************************************
 */

    /* Parameter adjustments */
    --a;
    --apnt;
    --y;

    /* Function Body */
    remain = *n % 8;

    switch (remain + 1) {
	case 1:  goto L2000;
	case 2:  goto L100;
	case 3:  goto L200;
	case 4:  goto L300;
	case 5:  goto L400;
	case 6:  goto L500;
	case 7:  goto L600;
	case 8:  goto L700;
    }

L100:
    i1 = apnt[2] - *m;
    a1 = -a[i1];
    i__1 = *m;
    for (i = 1; i <= i__1; ++i) {
	y[i] += a1 * a[i1];
	++i1;
/* L150: */
    }
    goto L2000;

L200:
    i1 = apnt[2] - *m;
    i2 = apnt[3] - *m;
    a1 = -a[i1];
    a2 = -a[i2];
    i__1 = *m;
    for (i = 1; i <= i__1; ++i) {
	y[i] = y[i] + a1 * a[i1] + a2 * a[i2];
	++i1;
	++i2;
/* L250: */
    }
    goto L2000;

L300:
    i1 = apnt[2] - *m;
    i2 = apnt[3] - *m;
    i3 = apnt[4] - *m;
    a1 = -a[i1];
    a2 = -a[i2];
    a3 = -a[i3];
    i__1 = *m;
    for (i = 1; i <= i__1; ++i) {
	y[i] = y[i] + a1 * a[i1] + a2 * a[i2] + a3 * a[i3];
	++i1;
	++i2;
	++i3;
/* L350: */
    }
    goto L2000;

L400:
    i1 = apnt[2] - *m;
    i2 = apnt[3] - *m;
    i3 = apnt[4] - *m;
    i4 = apnt[5] - *m;
    a1 = -a[i1];
    a2 = -a[i2];
    a3 = -a[i3];
    a4 = -a[i4];
    i__1 = *m;
    for (i = 1; i <= i__1; ++i) {
	y[i] = y[i] + a1 * a[i1] + a2 * a[i2] + a3 * a[i3] + a4 * a[i4];
	++i1;
	++i2;
	++i3;
	++i4;
/* L450: */
    }
    goto L2000;

L500:
    i1 = apnt[2] - *m;
    i2 = apnt[3] - *m;
    i3 = apnt[4] - *m;
    i4 = apnt[5] - *m;
    i5 = apnt[6] - *m;
    a1 = -a[i1];
    a2 = -a[i2];
    a3 = -a[i3];
    a4 = -a[i4];
    a5 = -a[i5];
    i__1 = *m;
    for (i = 1; i <= i__1; ++i) {
	y[i] = y[i] + a1 * a[i1] + a2 * a[i2] + a3 * a[i3] + a4 * a[i4] + a5 *
		 a[i5];
	++i1;
	++i2;
	++i3;
	++i4;
	++i5;
/* L550: */
    }
    goto L2000;

L600:
    i1 = apnt[2] - *m;
    i2 = apnt[3] - *m;
    i3 = apnt[4] - *m;
    i4 = apnt[5] - *m;
    i5 = apnt[6] - *m;
    i6 = apnt[7] - *m;
    a1 = -a[i1];
    a2 = -a[i2];
    a3 = -a[i3];
    a4 = -a[i4];
    a5 = -a[i5];
    a6 = -a[i6];
    i__1 = *m;
    for (i = 1; i <= i__1; ++i) {
	y[i] = y[i] + a1 * a[i1] + a2 * a[i2] + a3 * a[i3] + a4 * a[i4] + a5 *
		 a[i5] + a6 * a[i6];
	++i1;
	++i2;
	++i3;
	++i4;
	++i5;
	++i6;
/* L650: */
    }
    goto L2000;

L700:
    i1 = apnt[2] - *m;
    i2 = apnt[3] - *m;
    i3 = apnt[4] - *m;
    i4 = apnt[5] - *m;
    i5 = apnt[6] - *m;
    i6 = apnt[7] - *m;
    i7 = apnt[8] - *m;
    a1 = -a[i1];
    a2 = -a[i2];
    a3 = -a[i3];
    a4 = -a[i4];
    a5 = -a[i5];
    a6 = -a[i6];
    a7 = -a[i7];
    i__1 = *m;
    for (i = 1; i <= i__1; ++i) {
	y[i] = y[i] + a1 * a[i1] + a2 * a[i2] + a3 * a[i3] + a4 * a[i4] + a5 *
		 a[i5] + a6 * a[i6] + a7 * a[i7];
	++i1;
	++i2;
	++i3;
	++i4;
	++i5;
	++i6;
	++i7;
/* L750: */
    }
    goto L2000;

L2000:
    i__1 = *n;
    for (j = remain + 1; j <= i__1; j += 8) {
	i1 = apnt[j + 1] - *m;
	i2 = apnt[j + 2] - *m;
	i3 = apnt[j + 3] - *m;
	i4 = apnt[j + 4] - *m;
	i5 = apnt[j + 5] - *m;
	i6 = apnt[j + 6] - *m;
	i7 = apnt[j + 7] - *m;
	i8 = apnt[j + 8] - *m;
	a1 = -a[i1];
	a2 = -a[i2];
	a3 = -a[i3];
	a4 = -a[i4];
	a5 = -a[i5];
	a6 = -a[i6];
	a7 = -a[i7];
	a8 = -a[i8];
	i__2 = *m;
	for (i = 1; i <= i__2; ++i) {
	    y[i] = y[i] + a1 * a[i1] + a2 * a[i2] + a3 * a[i3] + a4 * a[i4] + 
		    a5 * a[i5] + a6 * a[i6] + a7 * a[i7] + a8 * a[i8];
	    ++i1;
	    ++i2;
	    ++i3;
	    ++i4;
	    ++i5;
	    ++i6;
	    ++i7;
	    ++i8;
/* L3000: */
	}
/* L4000: */
    }

    return 0;
} /* smxpy8_ */

