%%********************************************************************
%% scaling: scale the SDP data so that A_k,C,b have unit norm. 
%%          Because of scaling, the objective function is 
%%          modified: 
%% 
%%          old obj function = (normb*normC) (new obj function).
%%
%% SDPT3: version 3.0
%% Copyright (c) 1997 by
%% K.C. Toh, M.J. Todd, R.H. Tutuncu
%% Last modified: 2 Feb 01
%%********************************************************************

   function [Avec,C,b,X0,y0,Z0,normA,normC,normb] = scaling(blk,Avec,C,b,X0,y0,Z0); 

   m = length(b); 
   numblk = size(blk,1);  

   normA = zeros(m,1);  
   for p=1:numblk
       normA = normA + sqrt(sum(Avec{p}.*Avec{p}))';           
   end
   normA = max(1,normA);
%% 
   for p=1:numblk
       Avec{p} = Avec{p}*spdiags(1./normA,0,m,m); 
   end
   b = b./normA; normb = max(1,norm(b)); 
   b = b/normb; 
 
   normC = 0; 
   for p=1:numblk
       normC = normC + sum(sum(C{p}.*C{p})); 
   end 
   normC = sqrt(normC); 
   normC = max(1,normC);
   y0 = y0.*normA/normC; 
   for p=1:numblk
       X0{p} = X0{p}/normb; 
       C{p}  = C{p}/normC; 
       Z0{p} = Z0{p}/normC; 
   end
%%====================================================================

