function symbfct(P)
% SYMBFCT     - Symbolic factorization for sparse Cholesky factorization.
%            symbfct(P) does a minimum degree ordering and a symbolic
%            factorization for a symmetric square sparse matrix P, and 
%            passes the results as global variables.
%            It calls two Fortran MEX files.

% Yin Zhang, January, 1995
% Department of Mathematics and Statistics
% University of Maryland  Baltimore County

global XLNZ NNZL PERM INVP CACHE_SIZE
global XSUPER XLINDX LINDX SNODE SPLIT TMPSIZ

% ----- check input matrix P -----
m = size(P,1);
if size(P,2) ~= m | ~issparse(P) | isempty(P)
   error('Matrix must be square, sparse and nonempty.');
end;
Pdiag = diag(diag(P)); P = P - Pdiag;

% ----- min-degree ordering -----
t = cputime;
%fprintf('  min-degree ordering ... ');
   [PERM, INVP] = ordmmd(P);
%fprintf('Done. CPU seconds: %g\n',cputime-t);

% ----- symbalic factorization -----
t = cputime;
%fprintf('  calling symfct.mex* ... ');
[XLNZ,NNZL,XSUPER,XLINDX,LINDX,SNODE,SPLIT,TMPSIZ,PERM,INVP] = ...
                         symfct(P,PERM,INVP,CACHE_SIZE);
%fprintf('Done. CPU seconds: %g\n',cputime-t);

