%%***********************************************************************
%% validate: validate data
%%
%% [Avec,C,X0,Z0] = validate(blk,Avec,C,b,X0,y0,Z0);
%%
%% SDPT3: version 3.0 
%% Copyright (c) 1997 by
%% K.C. Toh, M.J. Todd, R.H. Tutuncu
%% Last modified: 2 Feb 01 
%%***********************************************************************

   function  [Avec,C,X0,Z0] = validate(blk,Avec,C,b,X0,y0,Z0);

   global spdensity

   if ~iscell(blk); 
      error('validate: blk must be a cell array'); end; 
   if size(blk,2)~=2
      error('validate: blk must be a cell array with 2 columns');       
   end 
   if ~iscell(Avec) | ~iscell(C); 
      error('validate: Avec, C must be cell arrays'); end;
   if (min(size(Avec))~=1 | min(size(C))~=1)
      error('validate: cell array Avec, C can only have 1 column or row'); end;
   if (size(Avec,2) > size(Avec,1));
      Avec = Avec'; end;
   if (size(C,2) > size(C,1));
      C = C'; end;
   if (nargin == 7)
      if ~iscell(X0) | ~iscell(Z0); 
         error('validate: X0, Z0 must be cell arrays'); 
      end;
      if (min(size(X0))~=1 | min(size(Z0))~=1); 
         error('validate: cell array X, Z can only have 1 column or row'); 
        if (size(X0,2) > size(X0,1));
           X0 = X0'; end;
        if (size(Z0,2) > size(Z0,1));
           Z0 = Z0'; end;
      end; 
   end
%%
%% 
   m = length(b);  numblk = size(blk,1);
   for p=1:size(blk,1)
      pblk = blk(p,:); 
      n = sum(pblk{2}); 
      numblk = length(pblk{2}); 
      if strcmp(pblk{1},'s');
         n2 = sum(pblk{2}.*pblk{2});  n22 = sum(pblk{2}.*(pblk{2}+1))/2; 
         if ~all(size(C{p}) == n) 
            error('validate: blk and C are not compatible'); end; 
         if (norm(C{p}-C{p}',inf) > 1e-13); 
            error('validate: C is not symmetric'); end;
         if (size(Avec{p}) == [m n22] & m~=n22); 
            Avec{p} = Avec{p}'; end
         if ~all(size(Avec{p}) == [n22, m])
            error('validate: blk and Avec not compatible'); end; 
         if (nnz(Avec{p}) < spdensity*n22*m)
            if ~issparse(Avec{p}); Avec{p} = sparse(Avec{p}); end              
         end
         if (nnz(C{p}) < spdensity*n2) | (numblk > 1); 
            if ~issparse(C{p}); C{p} = sparse(C{p}); end;
         else
            if issparse(C{p}); C{p} = full(C{p}); end; 
         end;
	 if (nargin == 7)
            if ~all(size(X0{p}) == n) | ~all(size(Z0{p}) == n); 
               error('validate: blk and X0,Z0 are not compatible'); end; 
            if (length(y0) ~= m); 
                error('validate: length of b and y0 not compatible'); end;  
            if (norm([X0{p}-X0{p}' Z0{p}-Z0{p}'],inf) > 2e-13); 
                error('validate: X0,Z0 not symmetric'); end;
            if (nnz(X0{p}) < spdensity*n2) | (numblk > 1) ; 
               if ~issparse(X0{p}); X0{p} = sparse(X0{p}); end; 
            else
               if issparse(X0{p}); X0{p} = full(X0{p}); end;
            end;
            if (nnz(Z0{p}) < spdensity*n2) | (numblk > 1); 
               if ~issparse(Z0{p}); Z0{p} = sparse(Z0{p}); end; 
            else
               if issparse(Z0{p}); Z0{p} = full(Z0{p}); end;
            end;
         end
      elseif strcmp(pblk{1},'q') | strcmp(pblk{1},'l'); 
         if (size(C{p},2) ~= 1); 
            error(['validate: ',num2str(p),'-th block of C must be column vectors']); 
         end;
         if (size(C{p},1) ~= n); 
            error(['validate: blk and C are not compatible']); 
         end; 
         if (size(Avec{p}) == [m n] & m~=n); 
            Avec{p} = Avec{p}'; end
         if ~all(size(Avec{p}) == [n,m]); 
            error('validate: blk and Avec not compatible'); end;
         if ~issparse(Avec{p}); 
            Avec{p} = sparse(Avec{p}); end; 
         if (nnz(C{p}) < spdensity*n); 
            if ~issparse(C{p}); C{p} = sparse(C{p}); end; 
         else
            if issparse(C{p}); C{p} = full(C{p}); end;
         end;
         if (nargin == 7)
            if ~all([size(X0{p},2) size(Z0{p},2)]==1); 
               error(['validate: ',num2str(p),'-th block of X0,Z0 must be column vectors']);
            end
            if ~all([size(X0{p},1) size(Z0{p},1)]==n); 
               error(['validate: blk, and X0,Z0, are not compatible']); 
            end;              
            if (nnz(X0{p}) < spdensity*n); 
               if ~issparse(X0{p}); X0{p} = sparse(X0{p}); end; 
            else
               if issparse(X0{p}); X0{p} = full(X0{p}); end;
            end;
            if (nnz(Z0{p}) < spdensity*n); 
               if ~issparse(Z0{p}); Z0{p} = sparse(Z0{p}); end; 
            else
               if issparse(Z0{p}); Z0{p} = full(Z0{p}); end;
            end;
         end
      else
         error(' blk: some fields are not specified correctly'); 
      end;
   end;
%%=============================================================






